% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_reshape.r
\name{remove_nodes}
\alias{remove_nodes}
\title{Remove nodes}
\usage{
remove_nodes(
  .tokens,
  node,
  rm_subset = NULL,
  with_fill = TRUE,
  rm_subset_fill = NULL,
  keep_shared = FALSE
)
}
\arguments{
\item{.tokens}{A tokenIndex in which nodes are selected with \link{select_nodes}.}

\item{node}{The name of the node that is to be mutated}

\item{rm_subset}{A subset expression (that evaluates to a logical vector) to more specifically specify which nodes to remove. The token column for each labeled node in the tquery can be referred to as label$column.}

\item{with_fill}{If TRUE, also remove the fill nodes}

\item{rm_subset_fill}{A subset on the fill nodes. Can only directly use token column. For example, use pos == 'VERB' to remove only verbs}

\item{keep_shared}{If there is another node that has the same fill nodes, should the fill nodes that are shared also be removed?}
}
\value{
A tokenIndex with a .nodes attribute
}
\description{
Remove nodes
}
\examples{
tokens = tokens_spacy[tokens_spacy$doc_id == 'text1',]

## use a tquery to label the nodes that you want to manipulate
tq = tquery(pos = 'VERB',
            children(label = 'object', relation='dobj'))

## apply query to select nodes
tokens2 = select_nodes(tokens, tq) 

remove_nodes(tokens2, 'object')
remove_nodes(tokens2, 'object', with_fill=FALSE)
}
