% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_as_docx.R
\name{export_as_docx}
\alias{export_as_docx}
\alias{section_properties_default}
\alias{margins_potrait}
\alias{margins_landscape}
\title{Export to a Word document}
\usage{
export_as_docx(
  tt,
  file,
  doc_metadata = NULL,
  titles_as_header = FALSE,
  footers_as_text = TRUE,
  template_file = NULL,
  section_properties = section_properties_default(),
  ...
)

section_properties_default(
  page_size = c("letter", "A4"),
  orientation = c("portrait", "landscape")
)

margins_potrait()

margins_landscape()
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{file}{(\code{string})\cr output file. Must have \code{.docx} extension.}

\item{doc_metadata}{(\code{list} of \code{string})\cr any value that can be used as metadata by
\code{\link[officer:set_doc_properties]{officer::set_doc_properties()}}. Important text values are \code{title}, \code{subject}, \code{creator}, and \code{description},
while \code{created} is a date object.}

\item{titles_as_header}{(\code{flag})\cr whether the table should be self-contained with additional header rows created
for titles and subtitles (\code{TRUE}), or titles and subtitles should be added as a paragraph of text above the table
(\code{FALSE}). Defaults to \code{FALSE}.}

\item{footers_as_text}{(\code{flag})\cr whether footers should be added as a new paragraph after the table (\code{TRUE}) or
the table should be self-contained, implementing \code{flextable}-style footnotes (\code{FALSE}) with the same style but a
smaller font. Defaults to \code{TRUE}.}

\item{template_file}{(\code{string})\cr template file that \code{officer} will use as a starting point for the final
document. Document attaches the table and uses the defaults defined in the template file.}

\item{section_properties}{(\code{officer::prop_section})\cr an \code{\link[officer:prop_section]{officer::prop_section()}} object which sets margins and
page size. Defaults to \code{\link[=section_properties_default]{section_properties_default()}}.}

\item{...}{(\code{any})\cr additional arguments passed to \code{\link[=tt_to_flextable]{tt_to_flextable()}}.}

\item{page_size}{(\code{string}) page size. Can be \code{"letter"} or \code{"A4"}. Defaults to \code{"letter"}.}

\item{orientation}{(\code{string}) page orientation. Can be \code{"portrait"} or \code{"landscape"}. Defaults to \code{"portrait"}.}
}
\value{
No return value, called for side effects
}
\description{
From an \code{rtables} table, produce a self-contained Word document or attach it to a template Word
file (\code{template_file}). This function is based on the \code{\link[=tt_to_flextable]{tt_to_flextable()}} transformer and
the \code{officer} package.
}
\section{Functions}{
\itemize{
\item \code{section_properties_default()}: Helper function that defines standard portrait properties for tables.

\item \code{margins_potrait()}: Helper function that defines standard portrait margins for tables.

\item \code{margins_landscape()}: Helper function that defines standard landscape margins for tables.

}}
\note{
\code{export_as_docx()} has few customization options available. If you require specific formats and details,
we suggest that you use \code{\link[=tt_to_flextable]{tt_to_flextable()}} prior to \code{export_as_docx()}. If the table is modified first using
\code{\link[=tt_to_flextable]{tt_to_flextable()}}, the \code{titles_as_header} and \code{footer_as_text} parameters must be re-specified.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2", "COUNTRY"))

tbl <- build_table(lyt, ex_adsl)

# See how the section_properties_portrait() function is built for customization
tf <- tempfile(fileext = ".docx")
export_as_docx(tbl,
  file = tf,
  section_properties = section_properties_default(orientation = "landscape")
)

}
\seealso{
\code{\link[=tt_to_flextable]{tt_to_flextable()}}
}
