% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{tt_to_flextable}
\alias{tt_to_flextable}
\alias{theme_docx_default}
\alias{theme_html_default}
\alias{word_mm_to_pt}
\title{Create a \code{flextable} from an \code{rtables} table}
\usage{
tt_to_flextable(
  tt,
  theme = theme_docx_default(),
  border = flextable::fp_border_default(width = 0.5),
  indent_size = NULL,
  titles_as_header = TRUE,
  bold_titles = TRUE,
  footers_as_text = FALSE,
  counts_in_newline = FALSE,
  paginate = FALSE,
  fontspec = NULL,
  lpp = NULL,
  cpp = NULL,
  ...,
  colwidths = NULL,
  tf_wrap = !is.null(cpp),
  max_width = cpp,
  total_page_height = 10,
  total_page_width = 10,
  autofit_to_page = TRUE
)

theme_docx_default(
  font = "Arial",
  font_size = 9,
  cell_margins = c(word_mm_to_pt(1.9), word_mm_to_pt(1.9), 0, 0),
  bold = c("header", "content_rows", "label_rows", "top_left"),
  bold_manual = NULL,
  border = flextable::fp_border_default(width = 0.5)
)

theme_html_default(
  font = "Courier",
  font_size = 9,
  cell_margins = 0.2,
  remove_internal_borders = "label_rows",
  border = flextable::fp_border_default(width = 1, color = "black")
)

word_mm_to_pt(mm)
}
\arguments{
\item{tt}{(\code{TableTree} or related class)\cr a \code{TableTree} object representing a populated table.}

\item{theme}{(\code{function} or \code{NULL})\cr a theme function designed to change the layout and style of a \code{flextable}
object. Defaults to \code{theme_docx_default()}, the classic Microsoft Word output style. If \code{NULL}, a table with style
similar to the \code{rtables} default will be produced. See Details below for more information.}

\item{border}{(\code{flextable::fp_border()})\cr border style. Defaults to \code{flextable::fp_border_default(width = 0.5)}.}

\item{indent_size}{(\code{numeric(1)})\cr indentation size. If \code{NULL}, the default indent size of the table (see
\code{\link[formatters:matrix_form]{formatters::matrix_form()}} \code{indent_size}, default is 2) is used. To work with \code{docx}, any size is multiplied by
1 mm (2.83 pt) by default.}

\item{titles_as_header}{(\code{flag})\cr whether the table should be self-contained and additional header rows created for
the \code{\link[formatters:title_footer]{formatters::main_title()}} string and \code{\link[formatters:title_footer]{formatters::subtitles()}} character vector (one row per element).
Defaults to \code{TRUE}. If \code{FALSE}, titles and subtitles are added as a paragraph of text above the table.}

\item{bold_titles}{(\code{flag} or \code{integer})\cr whether titles should be bold (defaults to \code{TRUE}). If one or more
integers are provided, these integers are used as indices for lines at which titles should be bold.}

\item{footers_as_text}{(\code{flag})\cr whether footers should be added as a new paragraph after the table (\code{TRUE}) or
the table should be self-contained, implementing \code{flextable}-style footnotes (\code{FALSE}) with the same style but a
smaller font. Defaults to \code{FALSE}.}

\item{counts_in_newline}{(\code{flag})\cr whether column counts should be printed on a new line. In \code{rtables}, column
counts (i.e. \code{(N=xx)}) are always printed on a new line (\code{TRUE}). For \code{docx} exports it may be preferred to print
these counts on the same line (\code{FALSE}). Defaults to \code{FALSE}.}

\item{paginate}{(\code{flag})\cr whether the \code{rtables} pagination mechanism should be used. If \code{TRUE}, this option splits
\code{tt} into multiple \code{flextables} as different "pages". When using \code{\link[=export_as_docx]{export_as_docx()}} we suggest setting this to
\code{FALSE} and relying only on the default Microsoft Word pagination system as co-operation between the two mechanisms
is not guaranteed. Defaults to \code{FALSE}.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[formatters:font_spec]{font_spec()}}.}

\item{lpp}{(\code{numeric(1)})\cr maximum lines per page including (re)printed header and context rows.}

\item{cpp}{(\code{numeric(1)} or \code{NULL})\cr width (in characters) of the pages for horizontal pagination.
\code{NA} (the default) indicates \code{cpp} should be inferred from the page size; \code{NULL} indicates no horizontal
pagination should be done regardless of page size.}

\item{...}{(\code{any})\cr additional parameters to be passed to the pagination function. See \code{\link[rtables:paginate]{rtables::paginate_table()}}
for options. If \code{paginate = FALSE} this argument is ignored.}

\item{colwidths}{(\code{numeric})\cr column widths for the resulting flextable(s). If \code{NULL}, the column widths estimated
with \code{\link[formatters:propose_column_widths]{formatters::propose_column_widths()}} will be used. When exporting into \code{.docx} these values are normalized
to represent a fraction of the \code{total_page_width}. If these are specified, \code{autofit_to_page} is set to \code{FALSE}.}

\item{tf_wrap}{(\code{flag})\cr whether the text for title, subtitles, and footnotes should be wrapped.}

\item{max_width}{(\code{integer(1)}, \code{string} or \code{NULL})\cr width that title and footer (including
footnotes) materials should be word-wrapped to. If \code{NULL}, it is set to the current print width of the
session (\code{getOption("width")}). If set to \code{"auto"}, the width of the table (plus any table inset) is
used. Parameter is ignored if \code{tf_wrap = FALSE}.}

\item{total_page_height}{(\code{numeric(1)})\cr total page height (in inches) for the resulting flextable(s). Used only
to estimate number of lines per page (\code{lpp}) when \code{paginate = TRUE}. Defaults to 10.}

\item{total_page_width}{(\code{numeric(1)})\cr total page width (in inches) for the resulting flextable(s). Any values
added for column widths are normalized by the total page width. Defaults to 10. If \code{autofit_to_page = TRUE}, this
value is automatically set to the allowed page width.}

\item{autofit_to_page}{(\code{flag})\cr whether column widths should be automatically adjusted to fit the total page
width. If \code{FALSE}, \code{colwidths} is used to indicate proportions of \code{total_page_width}. Defaults to \code{TRUE}.
See \code{flextable::set_table_properties(layout)} for more details.}

\item{font}{(\code{string})\cr font. Defaults to \code{"Arial"}. If the font given is not available, the \code{flextable} default
is used instead. For options, consult the family column from \code{\link[systemfonts:system_fonts]{systemfonts::system_fonts()}}.}

\item{font_size}{(\code{integer(1)})\cr font size. Defaults to 9.}

\item{cell_margins}{(\code{numeric(1)} or \code{numeric(4)})\cr a numeric or a vector of four numbers indicating
\code{c("left", "right", "top", "bottom")}. It defaults to 0 for top and bottom, and to 0.19 \code{mm} in Word \code{pt}
for left and right.}

\item{bold}{(\code{character})\cr parts of the table text that should be in bold. Can be any combination of
\code{c("header", "content_rows", "label_rows", "top_left")}. The first one renders all column names bold
(not \code{topleft} content). The second and third option use \code{\link[formatters:make_row_df]{formatters::make_row_df()}} to render content or/and
label rows as bold.}

\item{bold_manual}{(named \code{list} or \code{NULL})\cr list of index lists. See example for needed structure. Accepted
groupings/names are \code{c("header", "body")}.}

\item{remove_internal_borders}{(\code{character})\cr where to remove internal borders between rows. Defaults to
\code{"label_rows"}. Currently there are no other options and this can be turned off by providing any other character
value.}

\item{mm}{(\code{numeric(1)})\cr the value in mm to transform to pt.}
}
\value{
A \code{flextable} object.
}
\description{
Principally used within \code{\link[=export_as_docx]{export_as_docx()}}, this function produces a \code{flextable} from an \code{rtables} table.
If \code{theme = theme_docx_default()} (default), a \code{.docx}-friendly table will be produced.
If \code{theme = NULL}, the table will be produced in an \code{rtables}-like style.
}
\details{
If you would like to make a minor change to a pre-existing style, this can be done by extending themes. You can do
this by either adding your own theme to the theme call (e.g. \code{theme = c(theme_docx_default(), my_theme)}) or creating
a new theme as shown in the examples below. Please pay close attention to the parameters' inputs.

It is possible to use some hidden values to build your own theme (hence the need for the \code{...} parameter). In
particular, \code{\link[=tt_to_flextable]{tt_to_flextable()}} uses the following variable: \code{tbl_row_class = rtables::make_row_df(tt)$node_class}.
This is ignored if not used in the theme. See \code{\link[=theme_docx_default]{theme_docx_default()}} for an example on how to retrieve and use these
values.
}
\section{Functions}{
\itemize{
\item \code{theme_docx_default()}: Main theme function for \code{\link[=export_as_docx]{export_as_docx()}}.

\item \code{theme_html_default()}: Theme function for html outputs.

\item \code{word_mm_to_pt()}: Padding helper functions to transform mm to pt.

}}
\note{
Currently \code{cpp}, \code{tf_wrap}, and \code{max_width} are only used in pagination and should be used cautiously if used in
combination with \code{colwidths} and \code{autofit_to_page}. If issues arise, please raise an issue on GitHub or communicate
this to the package maintainers directly.
}
\examples{
analysisfun <- function(x, ...) {
  in_rows(
    row1 = 5,
    row2 = c(1, 2),
    .row_footnotes = list(row1 = "row 1 - row footnote"),
    .cell_footnotes = list(row2 = "row 2 - cell footnote")
  )
}

lyt <- basic_table(
  title = "Title says Whaaaat", subtitles = "Oh, ok.",
  main_footer = "ha HA! Footer!"
) \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", afun = analysisfun)

tbl <- build_table(lyt, ex_adsl)

# Example 1: rtables style ---------------------------------------------------
tt_to_flextable(tbl, theme = NULL)

# Example 2: docx style ------------------------------------------------------
tt_to_flextable(tbl, theme = theme_docx_default(font_size = 6))

# Example 3: Extending the docx theme ----------------------------------------
my_theme <- function(x, ...) {
  flextable::border_inner(x, part = "body", border = flextable::fp_border_default(width = 0.5))
}
flx <- tt_to_flextable(tbl, theme = c(theme_docx_default(), my_theme))

# Example 4: Creating a custom theme -----------------------------------------
special_bold <- list(
  "header" = list("i" = 1, "j" = c(1, 3)),
  "body" = list("i" = c(1, 2), "j" = 1)
)
custom_theme <- theme_docx_default(
  font_size = 10,
  font = "Brush Script MT",
  border = flextable::fp_border_default(color = "pink", width = 2),
  bold = NULL,
  bold_manual = special_bold
)
tt_to_flextable(tbl,
  border = flextable::fp_border_default(color = "pink", width = 2),
  theme = custom_theme
)

# Example 5: Extending the docx theme ----------------------------------------
my_theme <- function(font_size = 6) { # here can pass additional arguments for default theme
  function(flx, ...) {
    # First apply theme_docx_default
    flx <- theme_docx_default(font_size = font_size)(flx, ...)

    # Then apply additional styling
    flx <- flextable::border_inner(flx,
      part = "body",
      border = flextable::fp_border_default(width = 0.5)
    )

    return(flx)
  }
}
flx <- tt_to_flextable(tbl, theme = my_theme())

}
\seealso{
\code{\link[=export_as_docx]{export_as_docx()}}
}
