% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{indent_string}
\alias{indent_string}
\title{Indent Strings}
\usage{
indent_string(x, indent = 0, incr = 2, including_newline = TRUE)
}
\arguments{
\item{x}{a character vector}

\item{indent}{a vector of length \code{length(x)} with non-negative integers}

\item{incr}{non-negative integer: number of spaces per indent level}

\item{including_newline}{boolean: should newlines also be indented}
}
\value{
\code{x} indented by left-padding with code{indent*incr} white-spaces.
}
\description{
Used in rtables to indent row names for the ASCII output.
}
\examples{
indent_string("a", 0)
indent_string("a", 1)
indent_string(letters[1:3], 0:2)
indent_string(paste0(letters[1:3], "\n", LETTERS[1:3]), 0:2)

}
