% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{table_shell}
\alias{table_shell}
\alias{table_shell_str}
\title{Table shells}
\usage{
table_shell(tt, widths = NULL, col_gap = 3, hsep = default_hsep())

table_shell_str(tt, widths = NULL, col_gap = 3, hsep = default_hsep())
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a populated table.}

\item{widths}{widths of row.name and columns columns}

\item{col_gap}{gap between columns}

\item{hsep}{character to create line separator}
}
\value{
for \code{table_shell_str} the string representing the table shell, for \code{table_shell},
\code{NULL}, as the function is called for the side effect of printing the shell to the console
}
\description{
A table shell is a rendering of the table which maintains the structure, but does not
display the values, rather displaying the formatting instructions for each cell.
}
\examples{
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

l <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"), afun = list_wrap_x(summary) , format = "xx.xx")

tbl <- build_table(l, iris2)
table_shell(tbl)
}
