% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Viewer.R
\name{Viewer}
\alias{Viewer}
\title{Display an \code{rtable} object in the Viewer pane in RStudio or in a browser}
\usage{
Viewer(x, y = NULL, ...)
}
\arguments{
\item{x}{(\code{rtable} or \code{shiny.tag})\cr an object of class \code{rtable} or \code{shiny.tag} (defined in \code{htmltools} package).}

\item{y}{(\code{rtable} or \code{shiny.tag})\cr optional second argument of same type as \code{x}.}

\item{...}{arguments passed to \code{\link[=as_html]{as_html()}}.}
}
\value{
Not meaningful. Called for the side effect of opening a browser or viewer pane.
}
\description{
The table will be displayed using bootstrap styling.
}
\examples{
if (interactive()) {
  sl5 <- factor(iris$Sepal.Length > 5,
    levels = c(TRUE, FALSE),
    labels = c("S.L > 5", "S.L <= 5")
  )

  df <- cbind(iris, sl5 = sl5)

  lyt <- basic_table() \%>\%
    split_cols_by("sl5") \%>\%
    analyze("Sepal.Length")

  tbl <- build_table(lyt, df)

  Viewer(tbl)
  Viewer(tbl, tbl)


  tbl2 <- htmltools::tags$div(
    class = "table-responsive",
    as_html(tbl, class_table = "table")
  )

  Viewer(tbl, tbl2)
}
}
