% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{analyze}
\alias{analyze}
\title{Generate rows analyzing variables across columns}
\usage{
analyze(
  lyt,
  vars,
  afun = simple_analysis,
  var_labels = vars,
  table_names = vars,
  parent_name = NULL,
  format = NULL,
  na_str = NA_character_,
  nested = TRUE,
  inclNAs = FALSE,
  extra_args = list(),
  show_labels = c("default", "visible", "hidden"),
  indent_mod = 0L,
  section_div = NA_character_
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{vars}{(\code{character})\cr vector of variable names.}

\item{afun}{(\code{function})\cr analysis function. Must accept \code{x} or \code{df} as its first parameter. Can optionally take
other parameters which will be populated by the tabulation framework. See Details in \code{\link[=analyze]{analyze()}}.}

\item{var_labels}{(\code{character})\cr vector of labels for one or more variables.}

\item{table_names}{(\code{character})\cr names for the tables representing each atomic analysis. Defaults to \code{var}.}

\item{parent_name}{(\code{character(1)})\cr Name to assign to the table corresponding
to the \emph{split} or \emph{group of sibling analyses}, for \verb{split_rows_by*} and
\verb{analyze*} when analyzing more than one variable, respectively. Ignored when
analyzing a single variable.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{nested}{(\code{logical})\cr whether this layout instruction should be applied within the existing layout structure
\emph{if possible} (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split
underneath analyses, which is not allowed.}

\item{inclNAs}{(\code{logical})\cr whether NA observations in the \code{var} variable(s) should be included when performing
the analysis. Defaults to \code{FALSE}.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{show_labels}{(\code{string})\cr whether the variable labels corresponding to the variable(s) in \code{vars}
should be visible in the resulting table.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after the set of rows  defined
by (each sub-analysis/variable) of this analyze instruction, or
\code{NA_character_} (the default) for no section divider. This section
divider will be overridden by a split-level section divider when
both apply to the same position in the rendered output.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
Adding \emph{analyzed variables} to our table layout defines the primary tabulation to be performed. We do this by
adding calls to \code{analyze} and/or \code{\link[=analyze_colvars]{analyze_colvars()}} into our layout pipeline. As with adding further splitting,
the tabulation will occur at the current/next level of nesting by default.
}
\details{
When non-\code{NULL}, \code{format} is used to specify formats for all generated rows, and can be a character vector, a
function, or a list of functions. It will be repped out to the number of rows once this is calculated during the
tabulation process, but will be overridden by formats specified within \code{rcell} calls in \code{afun}.

The analysis function (\code{afun}) should take as its first parameter either \code{x} or \code{df}. Whichever of these the
function accepts will change the behavior when tabulation is performed as follows:
\itemize{
\item If \code{afun}'s first parameter is \code{x}, it will receive the corresponding subset \emph{vector} of data from the relevant
column (from \code{var} here) of the raw data being used to build the table.
\item If \code{afun}'s first parameter is \code{df}, it will receive the corresponding subset \emph{data frame} (i.e. all columns) of
the raw data being tabulated.
}

In addition to differentiation on the first argument, the analysis function can optionally accept a number of
other parameters which, \emph{if and only if} present in the formals, will be passed to the function by the tabulation
machinery. These are listed and described in \link{additional_fun_params}.
}
\note{
None of the arguments described in \link{additional_fun_params} can be overridden via \code{extra_args} or when calling
\code{\link[=make_afun]{make_afun()}}. \code{.N_col} and \code{.N_total} can be overridden via the \code{col_counts} argument to \code{\link[=build_table]{build_table()}}.
Alternative values for the others must be calculated within \code{afun} based on a combination of extra arguments and
the unmodified values provided by the tabulation framework.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", afun = list_wrap_x(summary), format = "xx.xx")
lyt

tbl <- build_table(lyt, DM)
tbl

lyt2 <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  analyze(head(names(iris), -1), afun = function(x) {
    list(
      "mean / sd" = rcell(c(mean(x), sd(x)), format = "xx.xx (xx.xx)"),
      "range" = rcell(diff(range(x)), format = "xx.xx")
    )
  })
lyt2

tbl2 <- build_table(lyt2, iris)
tbl2

}
\author{
Gabriel Becker
}
