% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_tika.R
\name{install_tika}
\alias{install_tika}
\title{Install or Update the Apache Tika \code{jar}}
\usage{
install_tika(version = "1.19.1",
  digest = paste0("629c09b60797d785571d0717aa39e1e27555c258994",
  "624f70181c33219e939126582e1dd4b72478c468667",
  "f998c3d173d251dcb752a85e285278e0c9f9b961c1"),
  mirrors = c("http://mirrors.ocf.berkeley.edu/apache/tika/",
  "http://apache.cs.utah.edu/tika/",
  "http://mirror.cc.columbia.edu/pub/software/apache/tika/"),
  retries = 2, url = character())
}
\arguments{
\item{version}{The declared Tika version}

\item{digest}{The sha15 checksum. Set to an empty string \code{""} to skip the check.}

\item{mirrors}{A vector Apache mirror sites. One is picked randomly.}

\item{retries}{The number of times to try the download.}

\item{url}{Optional url of a particular file to download. Will override downloading from random mirrors.}
}
\value{
Logical if the installation was successful.
}
\description{
This downloads and installs the Tika App \code{jar} (~60 MB) into a user directory,
and verifies the integrity of the file using a checksum.
The default settings should work fine.
}
\section{Details}{

The default settings of \code{install_tika()} should typically be left as they are.

This function will download the version of the Tika \code{jar} tested to work
with this package, and can verify file integrity using a checksum.

It will normally download from a random Apache mirror.
If the mirror fails,
it tries the archive at \code{http://archive.apache.org/dist/tika/}.
You can also enter a value for \code{url} directly to override this.

It will download into a directory determined
by the \code{rappdirs::user_data_dir()} function,
specific to the operating system.

If \code{tika()} is stopping with an error compalining about the \code{jar},
try running \code{install_tika()} again.
}

\section{Uninstalling}{

If you are uninstalling the entire \code{rtika} package
and want to remove the Tika App \code{jar} also,
run:

 \code{unlink(rappdirs::user_data_dir('rtika'), recursive = TRUE)}

Alternately, navigate to the install folder and delete it manually.
It is the file path returned by \code{rappdirs::user_data_dir('rtika')}.
The path is OS specific, and explained here:
https://github.com/r-lib/rappdirs .
}

\section{Distribution}{

Tika is distributed under the Apache License Version 2.0,
which generally permits distribution of the code "Object" without the "Source".
The master copy of the Apache Tika source code is held in GIT. 
You can fetch (clone) the large source from GitHub ( https://github.com/apache/tika ).
}

\examples{
\donttest{
install_tika()
}
}
