#' Get Ads
#'
#' @param advertiser_id Advertiser ID.
#' @param fields Fields that you want to get.
#'
#' @returns tibble with Ads metadata
#' @export
#'
tik_get_ads <- function(
    advertiser_id,
    fields = NULL
) {

  if (!is.null(fields)) fields <- toJSON(fields)
  params <- as.list(environment())

  res <- tik_build_request(
    endpoint = "ad/get/",
    params = params,
    resp_parse_function = tik_parsers$ads
  )

  return(res)

}
