% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{ClusterCategorical-class}
\alias{ClusterCategorical-class}
\title{Definition of the [\code{\linkS4class{ClusterCategorical}}] class}
\description{
This class defines a categorical mixture Model. Inherits from the
[\code{\linkS4class{IClusterModel}}] class. A categorical mixture model is
a mixture model of the form
}
\details{
\deqn{
  f({x}|\boldsymbol{\theta}) \\
  =\sum_{k=1}^K p_k \prod_{j=1}^d \mathcal{M}(x_j;p_{jk},1) \\
   \quad {x} \in \{1,\ldots,L\}^d.
}
}
\section{Slots}{

\describe{
\item{\code{plkj}}{Array with the probability of the jth variable in the kth cluster
to be l.}

\item{\code{nbModalities}}{Integer with the (maximal) number of modalities of the categorical
data.}
}}
\examples{
getSlots("ClusterCategorical")
  data(birds)
  new("ClusterCategorical", data=birds)
}
\author{
Serge Iovleff
}

