% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrANOVAFC.r
\name{qpcrANOVAFC}
\alias{qpcrANOVAFC}
\title{Fold change (\eqn{\Delta \Delta C_T} method) analysis using ANOVA and ANCOVA}
\usage{
qpcrANOVAFC(
  x,
  numberOfrefGenes,
  analysisType = "anova",
  mainFactor.column,
  mainFactor.level.order = NULL,
  block = NULL,
  width = 0.5,
  fill = "#BFEFFF",
  y.axis.adjust = 1,
  y.axis.by = 1,
  letter.position.adjust = 0.1,
  ylab = "Fold Change",
  xlab = "none",
  fontsize = 12,
  fontsizePvalue = 7,
  axis.text.x.angle = 0,
  axis.text.x.hjust = 0.5,
  x.axis.labels.rename = "none",
  p.adj = "none",
  errorbar = "se",
  plot = TRUE
)
}
\arguments{
\item{x}{a data frame of condition(s), biological replicates, efficiency (E) and Ct values of target and reference genes. Each Ct value in the data frame is the mean of technical replicates. NOTE: Each line belongs to a separate individual reflecting a non-repeated measure experiment). Please refer to the vignette for preparing your data frame correctly.}

\item{numberOfrefGenes}{number of reference genes which is 1 or 2 (Up to two reference genes can be handled).}

\item{analysisType}{should be one of "ancova" or "anova". Default is "anova".}

\item{mainFactor.column}{the factor for which FC is calculated for its levels. If \code{ancova} is selected as \code{analysisType}, the remaining factors (if any) are considered as covariate(s).}

\item{mainFactor.level.order}{NULL or a vector of main factor level names. If \code{NULL}, the first level of the \code{mainFactor.column} is used 
as reference or calibrator. If a vector of main factor levels (in any order) is specified, the first level in the vector is used as calibrator. Calibrator is the reference level or sample that all others are compared to. Examples are untreated 
of time 0. The FC value of the reference or calibrator level is 1 because it is not changed compared to itself.
If NULL, the first level of the main factor column is used as calibrator.}

\item{block}{column name of the block if there is a blocking factor (for correct column arrangement see example data.). When a qPCR experiment is done in multiple qPCR plates, variation resulting from the plates may interfere with the actual amount of gene expression. One solution is to conduct each plate as a complete randomized block so that at least one replicate of each treatment and control is present on a plate. Block effect is usually considered as random and its interaction with any main effect is not considered.}

\item{width}{a positive number determining bar width.}

\item{fill}{specify the fill color for the columns in the bar plot. If a vector of two colors is specified, the reference level is differentialy colored.}

\item{y.axis.adjust}{a negative or positive value for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length}

\item{letter.position.adjust}{adjust the distance between the signs and the error bars.}

\item{ylab}{the title of the y axis}

\item{xlab}{the title of the x axis}

\item{fontsize}{font size of the plot}

\item{fontsizePvalue}{font size of the pvalue labels}

\item{axis.text.x.angle}{angle of x axis text}

\item{axis.text.x.hjust}{horizontal justification of x axis text}

\item{x.axis.labels.rename}{a vector replacing the x axis labels in the bar plot}

\item{p.adj}{Method for adjusting p values}

\item{errorbar}{Type of error bar, can be \code{se} or \code{ci}.}

\item{plot}{if \code{FALSE}, prevents the plot.}
}
\value{
A list with 7 elements:
\describe{
  \item{Final_data}{Input data frame plus the weighted Delat Ct values (wDCt)}
  \item{lm_ANOVA}{lm of factorial analysis-tyle}
  \item{lm_ANCOVA}{lm of ANCOVA analysis-type}
  \item{ANOVA_table}{ANOVA table}
  \item{ANCOVA_table}{ANCOVA table}
  \item{FC Table}{Table of FC values, significance and confidence limits for the main factor levels.}
  \item{Bar plot of FC values}{Bar plot of the fold change values for the main factor levels.}
}
}
\description{
ANOVA (analysis of variance) and ANCOVA (analysis of covariance) can be performed using 
\code{qpcrANOVAFC} function, for uni- or multi-factorial experiment data. This function performs fold 
change or \eqn{\Delta \Delta C_T} method analysis for the target gene even
if there is only one factor (without covariate variable), although, for the data with 
only one factor, ANCOVA is equivalent to ANOVA. The bar plot of the fold changes (FC) 
values along with the standard error (se) and confidence interval (ci) is also returned by 
the \code{qpcrANOVAFC} function.
}
\details{
The \code{qpcrANOVAFC} function applies both ANOVA and ANCOVA analysis to the data of a uni- or 
multi-factorial experiment, although for the data with 
only one factor, the ANCOVA analysis is equivalent to ANOVA. ANCOVA is basically appropriate when the 
levels of a factor are #' also affected by uncontrolled quantitative covariate(s). 
For example, suppose that wDCt of a target gene in a plant is affected by temperature. The gene may 
also be affected by drought. Since we already know that temperature affects the target gene, we are 
interested to know if the gene expression is also altered by the drought levels. We can design an 
experiment to understand the gene behavior at both temperature and drought levels at the same time. 
The drought is another factor (the covariate) that may affect the expression of our gene under the 
levels of the first factor i.e. temperature. The data of such an experiment can be analyzed by ANCOVA 
or even ANOVA based on a factorial experiment using \code{qpcrANOVAFC}. This function performs FC 
analysis even there is only one factor (without covariate or factor  variable). Bar plot of fold changes 
(FC) values along with the pair-wise errors (square roots of pooled variances of each pair of samples) are also returned by the 
\code{qpcrANOVAFC} function. There is also a function called \code{oneFACTORplot} which returns RE values 
and related plot for a one-factor-experiment with more than two levels.
Along with the ANCOVA, the \code{qpcrANOVAFC} also performs a full model factorial analysis of variance. 
If there is covariate variable(s), before ANCOVA analysis, it is better to run ANOVA based on a 
factorial design to see if the main factor and covariate(s) interaction is significant or not. 
If the pvalue of the interaction effect is smaller than 0.05, then the interaction between the main factor and covariate 
is significant, suggesting that ANCOVA is not appropriate in this case.
}
\examples{


qpcrANOVAFC(data_1factor, numberOfrefGenes = 1, mainFactor.column = 1, 
fill = c("#CDC673", "#EEDD82"), fontsizePvalue = 5, y.axis.adjust = 0.1)


qpcrANOVAFC(data_2factor, numberOfrefGenes = 1, mainFactor.column = 2,  
analysisType = "ancova", fontsizePvalue = 5, y.axis.adjust = 0.4)


# Data from Lee et al., 2020 
# Here, the data set contains technical replicates so 
# we get mean of technical reps first:
df <- meanTech(Lee_etal2020qPCR, groups = 1:3)
order <- rev(unique(df$DS))
qpcrANOVAFC(df, numberOfrefGenes = 1, analysisType = "ancova", 
mainFactor.column = 2, fill = c("skyblue", "#BFEFFF"), y.axis.adjust = 0.05)


df <- meanTech(Lee_etal2020qPCR, groups = 1:3) 
df2 <- df[df$factor1 == "DSWHi",][-1]
qpcrANOVAFC(df2, mainFactor.column = 1, fontsizePvalue = 5, y.axis.adjust = 0.1,
mainFactor.level.order = c("D7", "D12", "D15","D18"),
numberOfrefGenes = 1, analysisType = "ancova")


qpcrANOVAFC(data_2factorBlock,  numberOfrefGenes = 1, mainFactor.column = 1, 
mainFactor.level.order = c("S", "R"), block = "block", 
fill = c("#CDC673", "#EEDD82"), analysisType = "ancova",
fontsizePvalue = 7, y.axis.adjust = 0.1, width = 0.35)


addline_format <- function(x,...){gsub('\\\\s','\n',x)}
order <- unique(data_2factor$Drought)
qpcrANOVAFC(data_1factor, numberOfrefGenes = 1, mainFactor.column = 1,
mainFactor.level.order = c("L1","L2","L3"), width = 0.5,
fill = c("skyblue","#79CDCD"), y.axis.by = 1, letter.position.adjust = 0,
y.axis.adjust = 1, ylab = "Fold Change", fontsize = 12,
x.axis.labels.rename = addline_format(c("Control", 
                                         "Treatment_1 vs Control", 
                                         "Treatment_2 vs Control")))
                                                       
                                                       
}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method. Methods 25 (4). doi:10.1006/meth.2001.1262.

Ganger, MT, Dietz GD, and Ewing SJ. 2017. A common base method for analysis of qPCR data
and the application of simple blocking in qPCR experiments. BMC bioinformatics 18, 1-11.

Yuan, Joshua S, Ann Reed, Feng Chen, and Neal Stewart. 2006.
Statistical Analysis of Real-Time PCR Data. BMC Bioinformatics 7 (85). doi:10.1186/1471-2105-7-85.
}
\author{
Ghader Mirzaghaderi
}
