% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplot.r
\name{multiplot}
\alias{multiplot}
\title{Multiple plot function}
\usage{
multiplot(..., cols = 1)
}
\arguments{
\item{...}{ggplot objects can be passed in ... or to plotlist (as a list of ggplot objects)}

\item{cols}{Number of columns in the panel}
}
\value{
A  multiple-plots plate
}
\description{
\code{multiplot} function combines multiple ggplot objects into a single plate.
}
\details{
Combining multiple ggplot objects into a single plate.
}
\examples{

p1 <- qpcrTTESTplot(data_ttest, 
                    numberOfrefGenes = 1,
                    ylab = "Average Fold Change (FC)",
                    width = 0.3)


out2 <- qpcrANOVARE(data_1factor, numberOfrefGenes = 1, block = NULL)$Result
p2 <- oneFACTORplot(out2,
                    width = 0.4,
                    fill = "skyblue",
                    y.axis.adjust = 0.5,
                    y.axis.by = 1,
                    errorbar = "ci",
                    show.letters = TRUE,
                    letter.position.adjust = 0.1,
                    ylab = "Relative Expression (RE)",
                    xlab = "Factor Levels",
                    fontsize = 12)
                    
multiplot(p1, p2, cols=2)

multiplot(p1, p2, cols=1)



}
\author{
gist.github.com/pedroj/ffe89c67282f82c1813d
}
