% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mentions.R
\name{get_mentions}
\alias{get_mentions}
\title{Get mentions for the authenticating user.}
\usage{
get_mentions(n = 200, since_id = NULL, max_id = NULL, parse = TRUE,
  token = NULL, ...)
}
\arguments{
\item{n}{Specifies the number of Tweets to try and retrieve, up to
a maximum of 200 (the default). The value of count is best
thought of as a limit to the number of tweets to return because
suspended or deleted content is removed after the count has been
applied.}

\item{since_id}{Returns results with an ID greater than (that is,
more recent than) the specified ID. There are limits to the
number of Tweets which can be accessed through the API. If the
limit of Tweets has occurred since the since_id, the since_id
will be forced to the oldest ID available.}

\item{max_id}{Character, returns results with an ID less than (that is,
older than) or equal to `max_id`.}

\item{parse}{Logical indicating whether to convert the response
object into an R list. Defaults to TRUE.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}

\item{...}{Other arguments passed as parameters in composed API
query.}
}
\value{
Tibble of mentions data.
}
\description{
Returns data on up to 200 of the most recent mentions (Tweets
containing a users's screen_name) of the authenticating user.
}
\details{
The timeline returned is the equivalent of the one seen
  when you view your mentions on twitter.com. This method can only
  return up to 800 tweets.
}
\examples{

\dontrun{

## get most recent 200 mentions of authenticating user
mymentions <- get_mentions()

## view data
mymentions

}

}
\seealso{
\url{https://developer.twitter.com/en/docs/tweets/timelines/api-reference/get-statuses-mentions_timeline}

Other tweets: \code{\link{get_favorites}},
  \code{\link{get_my_timeline}},
  \code{\link{get_timeline}}, \code{\link{lists_statuses}},
  \code{\link{lookup_statuses}},
  \code{\link{search_tweets}}, \code{\link{tweets_data}},
  \code{\link{tweets_with_users}}
}
\concept{tweets}
