% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{users_data}
\alias{users_data}
\alias{tweets_data}
\title{Get tweets from users, or users from tweets}
\usage{
users_data(tweets)

tweets_data(users)
}
\arguments{
\item{tweets}{A data frame of tweets.}

\item{users}{A data frame of users.}
}
\value{
\code{user_data()} returns a data frame of users; \code{tweets_data()}
returns a data frame of tweets.
}
\description{
Twitter API endpoints that return tweets also return data about the users who
tweeted, and most endpoints that return users also return their last tweet.
Showing these additional columns would clutter the default display, so
rtweet instead stores in special attributes and allows you to retrieve them
with the \code{user_data()} and \code{tweets_data()} helpers.
}
\examples{
if (auth_has_default()) {
# find users from tweets
tweets <- search_tweets("r")
users_data(tweets)

# from tweets from users
users <- search_users("r")
tweets_data(users)
}
}
