% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{PathSparreAndersen-class}
\alias{PathSparreAndersen-class}
\title{A formal S4 class PathSparreAndersen}
\description{
A formal S4 class to contain a simulated path of
\linkS4class{SparreAndersen} model.
}
\details{
Objects of the class must not be created manually. Instead, objects of this
class are returned by \code{\link{simulate_path}}.
}
\section{Slots}{

\describe{
\item{\code{model}}{an object of \linkS4class{CramerLundberg} class.}

\item{\code{path}}{a numeric matrix of columns \code{"time"} and \code{"X"} defining
the simulated path represented by pairs time-value.}

\item{\code{claim_sizes}}{a numeric vector of claims' sizes.}

\item{\code{claim_arrival_times}}{a numeric vector of claims' interarrival times.}

\item{\code{time_horizon}}{a numeric vector of the maximum time horizon achieved.}

\item{\code{is_ruined}}{a logical vector indicating whether the process is ruined.}

\item{\code{elapsed_time}}{a numeric vector of the elapsed simulation time in
seconds.}

\item{\code{max_time_horizon}}{a numeric vector of the maximum time horizon allowed.}

\item{\code{max_simulation_time}}{a numeric vector of the maximum simulation time
in seconds.}

\item{\code{seed}}{a numeric vector indicating the seed used for simulation.}
}}

\seealso{
\linkS4class{SparreAndersen} (class definition),
\code{\link{SparreAndersen}} (constructor).
}
