% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wku_stats}
\alias{wku_stats}
\alias{wku_probs}
\title{Player statistics and probabilities for WKU softball}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 18 rows and 23 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 18 rows and 11 columns.
}
\source{
\url{https://wkusports.com/sports/softball/stats/}
}
\usage{
wku_stats

wku_probs
}
\description{
Statistics and calculated probabilities for each player on 
    the 2013 Western Kentucky University softball team. Data is stored in 
    two data frames: \code{wku_stats} contains the game statistics for 
    each player and \code{wku_probs} contains the calculated probabilities 
    for each player.  Player names and numbers have been replaced with 
    random letters/numbers to preserve anonymity.
}
\details{
\code{wku_stats} contains the raw player data taken from the 2013 WKU
    softball team's webpage.  \code{wku_probs} contains the 
    player probabilities calculated using \code{prob_calc}.  Together, they provide
    an example of calculating probabilities from player statistics.  See 
    \code{?prob_calc} for more details on the columns of the two data frames.
    
    \code{wku_probs} is designed for use with \code{chain} and \code{sim}.  It 
    additionally contains a \code{fast} column that indicates whether each player is
    considered fast.  This column is not necessary for running \code{chain} 
    and \code{sim}, since it is equivalent to the default assignments.
}
\examples{
probs <- prob_calc(wku_stats)   # probs corresponds to wku_probs

}
\keyword{datasets}
