% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Mfd.R
\name{getSymbols.Mfd}
\alias{getSymbols.Mfd}
\title{Get financial data from Mfd.ru}
\usage{
getSymbols.Mfd(
  Symbols,
  env = globalenv(),
  from = "2007-01-01",
  to = Sys.Date(),
  adjust = FALSE,
  period = "day",
  verbose = TRUE,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{character vector of symbols to retrieve}

\item{env}{environment where the data will be assigned}

\item{from}{a character string representing the starting date in 'YYYY-MM-DD' format. Default is '2007-01-01'.}

\item{to}{a character string representing the ending date in 'YYYY-MM-DD' format. Default is the current system date.}

\item{adjust}{a logical specifying whether to adjust for dividends and stock splits. Default is FALSE.}

\item{period}{a character string specifying the period of the data to retrieve. Must be one of 'tick', '1min', '5min', '10min', '15min', '30min', 'hour', 'day', 'week', or 'month'. Default is 'day'.}

\item{verbose}{a logical specifying whether to print progress messages. Default is TRUE.}

\item{auto.assign}{a logical specifying whether to automatically assign the retrieved data to the symbols specified in the Symbols argument. Default is FALSE.}

\item{...}{additional arguments passed to getSymbols.Mfd}
}
\value{
If auto.assign is TRUE, the function returns the Symbols argument with the retrieved data assigned to each symbol. If auto.assign is FALSE, the function returns an xts object.
}
\description{
This function retrieves financial data from Mfd.ru
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\author{
Vyacheslav Arbuzov
}
