% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{conv}
\alias{conv}
\title{Create a convolutional layer}
\usage{
conv(
  filters,
  kernel_size,
  padding = "same",
  max_pooling = NULL,
  average_pooling = NULL,
  upsampling = NULL,
  activation = "linear"
)
}
\arguments{
\item{filters}{Number of filters learned by the layer}

\item{kernel_size}{Integer or list of integers indicating the size of the weight
matrices to be convolved with the image}

\item{padding}{One of "valid" or "same" (case-insensitive). See
\code{\link[keras]{layer_conv_2d}} for more details}

\item{max_pooling}{\code{NULL} or an integer indicating the reduction ratio for a max
pooling operation after the convolution}

\item{average_pooling}{\code{NULL} or an integer indicating the reduction ratio for
an average pooling operation after the convolution}

\item{upsampling}{\code{NULL} or an integer indicating the augmentation ratio for an
upsampling operation after the convolution}

\item{activation}{Optional, string indicating activation function (linear by default)}
}
\value{
A construct with class \code{"ruta_network"}
}
\description{
Wrapper for a convolutional layer. The dimensions of the convolution operation are
inferred from the shape of the input data. This shape must follow the pattern
\code{(batch_shape, x, [y, [z, ]], channel)} where dimensions \code{y} and \code{z}
are optional, and \code{channel} will be either \code{1} for grayscale images or
generally \code{3} for colored ones.
}
\examples{
# Sample convolutional autoencoder
net <- input() +
 conv(16, 3, max_pooling = 2, activation = "relu") +
 conv(8, 3, max_pooling = 2, activation = "relu") +
 conv(8, 3, upsampling = 2, activation = "relu") +
 conv(16, 3, upsampling = 2, activation = "relu") +
 conv(1, 3, activation = "sigmoid")
}
\seealso{
Other neural layers: 
\code{\link{dense}()},
\code{\link{dropout}()},
\code{\link{input}()},
\code{\link{layer_keras}()},
\code{\link{output}()},
\code{\link{variational_block}()}
}
\concept{neural layers}
