% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rv.R
\name{plot.rv}
\alias{plot.rv}
\alias{plot.rvsummary}
\title{Plotting Scatterplots of Random Variable Objects}
\usage{
\method{plot}{rv}(x, y = NULL, ...)
}
\arguments{
\item{x}{an rv object}

\item{y}{random or fixed vector}

\item{\dots}{other arguments passed on to \code{plot}}
}
\description{
Draw a "random scatter plot" or random points as horizontal or vertical
intervals.
}
\details{
If a component \code{x} is fixed and the corresponding component of \code{y}
is random, the resulting `point' is a vertical uncertainty ('credible')
interval.  \emph{NOTE.} You must call \code{plot.rv} explicitly to obtain
this behavior.

If a component \code{y} is fixed and the corresponding component of \code{x}
is random, the resulting `point' is a horizontal uncertainty ('credible')
interval.

If a component of \code{x} and the corresponding component of \code{y} is
random, the resulting `point' is a scatterplot of simulations from the joint
distribution of code(x,y).

Compatible with objects of class `rvsummary'.
}
\examples{

  x <- as.rv(1:30)
  y <- rvnorm(mean=x, sd=1)
  \dontrun{plot(x, y)}
  \dontrun{plot(y, x)}
  \dontrun{plot(y)}
  y <- as.rvsummary(x)
  \dontrun{plot(x, y)}
  \dontrun{plot(y, x)}
  \dontrun{plot(y)}

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{mlplot}}
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{aplot}
