% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_rv.R, R/cov_rv.R, R/rv-package.R,
%   R/sd_rv.R, R/var_rv.R
\name{cor.rv}
\alias{cor.rv}
\alias{cov.rv}
\alias{distrib_rv}
\alias{var.rv}
\alias{sd.rv}
\title{Calculate the covariance of an rv object}
\usage{
cor.rv(x, y = NULL, ...)

cov.rv(x, y = NULL, ...)

sd.rv(x, na.rm = FALSE)

var.rv(x, ...)
}
\arguments{
\item{x}{a numeric or random vector, matrix, or a data frame}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with
compatible dimensions to x. The default is equivalent to y = x (but more
efficient).}

\item{\dots}{arguments passed to stats::var}

\item{na.rm}{logical. Should missing values be removed?}
}
\value{
A random vector or array.
}
\description{
\code{var.rv}, \code{cov.rv} and \code{cor.rv} compute the distribution of
the variance statistic of x and the distribution of the covariance statistic
or the correlation statistic of x and y if these are vectors.  If x and y
are matrices then the covariances (or correlations) between the columns of x
and the columns of y are computed.
}
\details{
These functions are compatible with \emph{both} numeric and rv objects.  To
make your code compatible with \code{rv} objects, use e.g. \code{sd.rv}
instead of \code{sd}.

The functions \code{cov.rv} is implemented by applying the corresponding
numerical function to the rows of the simulation matrices of \code{x} and
\code{y} and forming a new \code{rv} object from the resulting vector of
simulations.  Alternatively \code{x} may be a random matrix (and \code{y}
\code{NULL}).  \%Then the numerical function \code{cov}.

\code{cor.rv} works similarly, but returns the distribution of the
correlation statistic (i.e. function).

\code{var.rv} computes the distribution of the variance statistic.
\code{sd.rv} is the square root of the result obtained by \code{var.rv}.
}
\examples{

  #

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{internal}
