% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_list_col.R
\name{as_list_col}
\alias{as_list_col}
\alias{as_list_col.rvec}
\alias{as_list_col.matrix}
\title{Convert to List Column}
\usage{
as_list_col(x)

\method{as_list_col}{rvec}(x)

\method{as_list_col}{matrix}(x)
}
\arguments{
\item{x}{An \link[=rvec]{rvecs} or matrix.}
}
\value{
A list:
\itemize{
\item If \code{x} is an \code{rvec}, then the list contains
\code{length(x)} vectors, each of which has
\code{n_draw(x)} elements.
\item If \code{x} is a matrix, then the list contains
\code{nrow(x)} vectors, each of which has
\code{ncol(x)} elements.
}
}
\description{
Convert an \link[=rvec]{rvec} or matrix
to a list that can be used
as a list column in a data frame.
}
\examples{
l <- list(1:3,
          4:6)
r <- rvec(l)
as_list_col(r)
}
\seealso{
\itemize{
\item \code{\link[=rvec]{rvec()}} to construct an \code{rvec}.
\item \code{\link[=expand_from_rvec]{expand_from_rvec()}} to convert a data frame
from using \code{rvec}s to using \code{draw} and \code{value}
columns.
\item as_rvar???
\item converting \code{rvec}s to
\item Functions for summarising and plotting
distributions in package
\href{https://CRAN.R-project.org/package=ggdist}{ggdist}
understand list columns.
}
}
