% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{fqpskmod}
\alias{fqpskmod}
\title{QPSK Modulator}
\usage{
fqpskmod(bits, Ns = 1, p = 1)
}
\arguments{
\item{bits}{- received vector of bits (0's and 1's).}

\item{Ns}{- N samples per symbol (default, Ns = 1)}

\item{p}{- a vector defining the pulse shape of the transmitted waveform (default, p = 1)}
}
\value{
Returns a complex vector of QPSK symbols. If Ns > 1
then the returned signal is shaped with pulse shape, p.
}
\description{
Receives a vector of bits (1's and 0's). The 1's and 0's are
mapped to in-phase (real) and quadrature (imaginary) components.
Correspondingly, a bit of 1 is mapped to +1/sqrt(2), otherwise to -1/sqrt(2)
according to the following mapping.
 \tabular{cc}{
input \tab output \cr
00 \tab  (-1 - 1i) / sqrt(2)  \cr
01 \tab  (-1 + 1i) / sqrt(2) \cr
10 \tab  (+1 - 1i) / sqrt(2) \cr
11 \tab  (+1 + 1i) / sqrt(2)
}
}
\examples{
M=4
Nsymbols=10
Nbits=log2(M)*Nsymbols
bits <- sample(0:1,Nbits, replace=TRUE)
s <- fqpskmod(bits)
}

