#' Get \emph{DESCRIPTION} files for R repos
#' 
#' Get the \emph{DESCRIPTION} file information in
#'  \link[data.table]{data.table} format for all R packages 
#' in standard R repositories (CRAN, Bioc).
#'  Can return a subset of results for specific packages as well.
#' @param db A \link[data.table]{data.table} of R package metadata generated by
#'  \link[BiocPkgTools]{biocPkgList}.
#' @inheritParams get_description
#' @inheritParams BiocPkgTools::biocPkgList
#' @returns Named list of \link[desc]{desc} objects.
#' 
#' @keywords internal 
#' @importFrom BiocManager version
#' @importFrom utils data
get_description_repo <- function(refs = NULL,
                                 db = NULL,
                                 repo = c("BioCsoft", 
                                          "BioCann", 
                                          "BioCexp",
                                          "BioCworkflows", 
                                          "CRAN"), 
                                 version = BiocManager::version(),
                                 verbose = TRUE){
  # devoptera::args2vars(get_description_repo, reassign = TRUE)
  
  force(refs)
  messager("Searching for DESCRIPTION file(s) in R repositories:",
           paste(repo,collapse = ", "),v=verbose)
  #### Get package metadata across repositories ####
  if(is.null(db)){
    db <- get_description_repo_biocpkgtools(refs = refs, 
                                            repo = repo,  
                                            version = version,
                                            verbose = verbose) 
  }
  dt_to_desc(db = db,
             refs = refs,
             verbose = verbose)
  
  # tools::CRAN_package_db() 
  # report <- BiocPkgTools::biocBuildReport() 
  # BiocPkgTools::githubDetails(pkgs = "bschilder/scKirby") 
  # dep_df = buildPkgDependencyDataFrame()
  # g = buildPkgDependencyIgraph(dep_df)
  # g2 = subgraphByDegree(g, "orthogene",degree = 1)
  # library(visNetwork)
  # data <- toVisNetworkData(g2)
  # visNetwork(nodes = data$nodes, edges = data$edges, height = "500px") |>
  #   visEdges(arrows='from') 
  
  
  # fields <- pkgsearch::cran_package(name = pkg)   
  # miniCRAN::addPackageListingGithub(repo = ) 
  # deepdep::deepdep(package = "rworkflows",depth = 2,bioc = TRUE)
  # d <- deepdep::get_description(package = "rworkflows") 
  # deepdep::plot_downloads("htmltools")
}
