% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symengine.R
\name{rxToSE}
\alias{rxToSE}
\alias{.rxToSE}
\alias{rxFromSE}
\alias{.rxFromSE}
\title{rxode2 to symengine environment}
\usage{
rxToSE(x, envir = NULL, progress = FALSE, promoteLinSens = TRUE)

.rxToSE(x, envir = NULL, progress = FALSE)

rxFromSE(x, unknownDerivatives = c("forward", "central", "error"))

.rxFromSE(x)
}
\arguments{
\item{x}{expression}

\item{envir}{default is \code{NULL}; Environment to put symengine
variables in.}

\item{progress}{shows progress bar if true.}

\item{promoteLinSens}{Promote solved linear compartment systems to
sensitivity-based solutions.}

\item{unknownDerivatives}{When handling derivatives from unknown
functions, the translator will translate into different types
of numeric derivatives.  The currently supported methods are:

\if{html}{\out{<div class="sourceCode">}}\preformatted{- `forward` for forward differences
- `central` for central differences
- `error` for throwing an error for unknown derivatives
}\if{html}{\out{</div>}}}
}
\value{
An rxode2 symengine environment
}
\description{
rxode2 to symengine environment
}
\author{
Matthew L. Fidler
}
