% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prelu.R
\name{dPReLU}
\alias{dPReLU}
\alias{dPReLUa}
\alias{dPReLUa1}
\title{Derivatives Parametric ReLU Activation Function}
\usage{
dPReLU(x, alpha = 1)

dPReLUa(x, alpha = 1)

dPReLUa1(x, alpha = 1)
}
\arguments{
\item{x}{A numeric vector. All elements must be finite and
non-missing.}

\item{alpha}{A numeric scalar. All elements must be finite and
non-missing.}
}
\value{
A numeric vector where the derivative(s) of the ELU function has been applied
to each element of \code{x}.
}
\description{
Derivatives Parametric ReLU Activation Function
}
\examples{

dPReLU(c(-1, 0, 1, 2), 2)
dPReLUa(c(-1, 0, 1, 2), 2)
dPReLUa1(c(-1, 0, 1, 2), 2)


# Can also be used in rxode2:
r <- rxode2({
  r1=dPReLU(time, 2)
  r2a=dPReLUa(time, 2)
  ra=dPReLUa1(time, 2)
})

e <- et(c(-1, 0, 1, 2))
rxSolve(r, e)
}
\seealso{
Other Activation Functions: 
\code{\link{ELU}()},
\code{\link{GELU}()},
\code{\link{PReLU}()},
\code{\link{ReLU}()},
\code{\link{SELU}()},
\code{\link{Swish}()},
\code{\link{dELU}()},
\code{\link{dGELU}()},
\code{\link{dReLU}()},
\code{\link{dSELU}()},
\code{\link{dSwish}()},
\code{\link{dlReLU}()},
\code{\link{dsoftplus}()},
\code{\link{lReLU}()},
\code{\link{softplus}()}
}
\author{
Matthew L. Fidler
}
\concept{Activation Functions}
