% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{binomProbs}
\alias{binomProbs}
\alias{binomProbs.default}
\title{Calculate expected confidence bands with binomial sampling distribution}
\usage{
binomProbs(x, ...)

\method{binomProbs}{default}(
  x,
  probs = c(0.025, 0.05, 0.5, 0.95, 0.975),
  na.rm = FALSE,
  names = TRUE,
  onlyProbs = TRUE,
  n = 0L,
  m = 0L,
  pred = FALSE,
  piMethod = c("lim"),
  M = 5e+05,
  tol = .Machine$double.eps^0.25,
  ciMethod = c("wilson", "wilsonCorrect", "agrestiCoull", "wald", "wc", "ac"),
  ...
)
}
\arguments{
\item{x}{numeric vector whose mean and probability based confidence
values are wanted, NA and NaN values are not allowed in numeric
vectors unless \code{na.rm} is \code{TRUE}.}

\item{...}{Arguments passed to default method, allows many
different methods to be applied.}

\item{probs}{numeric vector of probabilities with values in the
interval 0 to 1, inclusive. When 0, it represents the maximum
observed, when 1, it represents the maximum observed. When 0.5 it
represents the expected probability (mean).}

\item{na.rm}{logical; if true, any NA and NaN's are removed from
\code{x} before the quantiles are computed.}

\item{names}{logical; if true, the result has a names attribute.}

\item{onlyProbs}{logical; if true, only return the probability
based confidence interval/prediction interval estimates,
otherwise return extra statistics.}

\item{n}{integer/integerish; this is the n used to calculate the
prediction or confidence interval.  When \code{n=0} (default) use the
number of non-\code{NA} observations.  When calculating the prediction
interval, this represents the number of observations used in the
input ("true") distribution.}

\item{m}{integer.  When using the prediction interval this
represents the number of samples that will be observed in the
future for the prediction interval.}

\item{pred}{Use a prediction interval instead of a confidence
interval.  By default this is \code{FALSE}.}

\item{piMethod}{gives the prediction interval method (currently only lim) from Lu 2020}

\item{M}{number of simulations to run for the LIM PI.}

\item{tol}{tolerance of root finding in the LIM prediction interval}

\item{ciMethod}{gives the method for calculating the confidence
interval.

Can be:
\itemize{
\item "argestiCoull" or "ac" -- Agresti-Coull method. For a 95\\% confidence
interval, this method does not use the concept   of "adding 2
successes and 2 failures," but rather uses the formulas explicitly
described in the following link:
}

https://en.wikipedia.org/wiki/Binomial_proportion_confidence_interval#Agresti-Coull_Interval.
\itemize{
\item "wilson" -- Wilson Method
\item "wilsonCorrect" or "wc" -- Wilson method with continuity correction
\item "wald" -- Wald confidence interval or standard z approximation.
}}
}
\value{
By default the return has the probabilities as names (if
named) with the points where the expected distribution are
located given the sampling mean and standard deviation. If
\code{onlyProbs=FALSE} then it would prepend mean, variance, standard
deviation, minimum, maximum and number of non-NA observations.
}
\description{
This is meant to perform in the same way as \code{quantile()} so it can
be a drop in replacement for code using \code{quantile()} but using
distributional assumptions.
}
\details{
It is used for confidence intervals with rxode2 solved objects using
\code{confint(mean="binom")}
}
\examples{

x<- rbinom(7001, p=0.375, size=1)
binomProbs(x)

# you can also use the prediction interval
\donttest{
binomProbs(x, pred=TRUE)
}

# Can get some extra statistics if you request onlyProbs=FALSE
binomProbs(x, onlyProbs=FALSE)

x[2] <- NA_real_

binomProbs(x, onlyProbs=FALSE)

binomProbs(x, na.rm=TRUE)

}
\references{
\itemize{
\item Newcombe, R. G. (1998). "Two-sided confidence intervals for the single
proportion: comparison of seven methods". Statistics
in Medicine. 17 (8):
857–872. doi:10.1002/(SICI)1097-0258(19980430)17:8<857::AID-SIM777>3.0.CO;2-E. PMID
9595616.
\item Hezhi Lu, Hua Jin,
A new prediction interval for binomial random variable based on inferential models,
Journal of Statistical Planning and Inference,
Volume 205,
2020,
Pages 156-174,
ISSN 0378-3758,
https://doi.org/10.1016/j.jspi.2019.07.001.
}
}
\author{
Matthew L. Fidler
}
