% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clim.R
\name{Clim}
\alias{Clim}
\title{Compute Bias Corrected Climatologies}
\usage{
Clim(exp, obs, time_dim = "sdate", dat_dim = c("dataset", "member"),
  method = "clim", ftime_dim = "ftime", memb = TRUE,
  memb_dim = "member", na.rm = TRUE, ncores = NULL)
}
\arguments{
\item{exp}{A named numeric array of experimental data, with at least two 
dimensions 'time_dim' and 'dat_dim'.}

\item{obs}{A named numeric array of observational data, same dimensions as
parameter 'exp' except along 'dat_dim'.}

\item{time_dim}{A character string indicating the name of dimension along
which the climatologies are computed. The default value is 'sdate'.}

\item{dat_dim}{A character vector indicating the name of the dataset and 
member dimensions. If data at one startdate (i.e., 'time_dim') are not 
complete along 'dat_dim', this startdate along 'dat_dim' will be discarded.
The default value is "c('dataset', 'member')".}

\item{method}{A character string indicating the method to be used. The 
options include 'clim', 'kharin', and 'NDV'. The default value is 'clim'.}

\item{ftime_dim}{A character string indicating the name of forecast time
dimension. Only used when method = 'NDV'. The default value is 'ftime'.}

\item{memb}{A logical value indicating whether to remain 'memb_dim' dimension
(TRUE) or do ensemble mean over 'memb_dim' (FALSE). The default value is TRUE.}

\item{memb_dim}{A character string indicating the name of the member 
dimension. Only used when parameter 'memb' is FALSE. It must be one element
in 'dat_dim'. The default value is 'member'.}

\item{na.rm}{A logical value indicating whether to remove NA values along 
'time_dim' when calculating climatology (TRUE) or return NA if there is NA 
along 'time_dim' (FALSE). The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list of 2:
\item{$clim_exp}{
 A numeric array with the same dimensions as parameter 'exp' but 
 dimension 'time_dim' is moved to the first position. If parameter 'method'
 is 'clim', dimension 'time_dim' is removed. If parameter 'memb' is FALSE,
 dimension 'memb_dim' is also removed.
}
\item{$clim_obs}{
 A numeric array with the same dimensions as  parameter 'exp' 
 except dimension 'time_dim' is removed. If parameter 'memb' is FALSE,
 dimension 'memb_dim' is also removed.
}
}
\description{
This function computes per-pair climatologies for the experimental 
and observational data using one of the following methods:
\enumerate{
 \item{per-pair method (Garcia-Serrano and Doblas-Reyes, CD, 2012)}
 \item{Kharin method (Karin et al, GRL, 2012)}
 \item{Fuckar method (Fuckar et al, GRL, 2014)}
}
Per-pair climatology means that only the startdates covered by the 
whole experiments/observational dataset will be used. In other words, the 
startdates which are not all available along 'dat_dim' dimension of both
the 'exp' and 'obs' are excluded when computing the climatologies.
}
\examples{
# Load sample data as in Load() example:
example(Load)
clim <- Clim(sampleData$mod, sampleData$obs)
clim2 <- Clim(sampleData$mod, sampleData$obs, method = 'kharin', memb = FALSE)
\donttest{
PlotClim(clim$clim_exp, clim$clim_obs, 
        toptitle = paste('sea surface temperature climatologies'), 
        ytitle = 'K', monini = 11, listexp = c('CMIP5 IC3'), 
        listobs = c('ERSST'), biglab = FALSE, fileout = 'tos_clim.eps')
}
}

