% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Eno.R
\name{Eno}
\alias{Eno}
\title{Compute effective sample size with classical method}
\usage{
Eno(data, time_dim = "sdate", na.action = na.pass, ncores = NULL)
}
\arguments{
\item{data}{A numeric array with named dimensions.}

\item{time_dim}{A function indicating the dimension along which to compute 
the effective sample size. The default value is 'sdate'.}

\item{na.action}{A function. It can be na.pass (missing values are allowed) 
or na.fail (no missing values are allowed). See details in stats::acf(). 
The default value is na.pass.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
An array with the same dimension as parameter 'data' except the 
 time_dim dimension, which is removed after the computation. The array  
 indicates the number of effective sample along time_dim.
}
\description{
Compute the number of effective samples along one dimension of an array. This
effective number of independent observations can be used in
statistical/inference tests.\cr
The calculation is based on eno function from Caio Coelho from rclim.txt.
}
\examples{
set.seed(1)
data <- array(rnorm(800), dim = c(dataset = 1, member = 2, sdate = 4, 
                                 ftime = 4, lat = 10, lon = 10))
na <- floor(runif(40, min = 1, max = 800))
data[na] <- NA
res <- Eno(data)

}

