% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSSS.R
\name{RMSSS}
\alias{RMSSS}
\title{Compute root mean square error skill score}
\usage{
RMSSS(
  exp,
  obs,
  time_dim = "sdate",
  dat_dim = "dataset",
  pval = TRUE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numeric array of experimental data which contains at least
two dimensions for dat_dim and time_dim. It can also be a vector with the 
same length as 'obs', then the vector will automatically be 'time_dim' and 
'dat_dim' will be 1.}

\item{obs}{A named numeric array of observational data which contains at least
two dimensions for dat_dim and time_dim. The dimensions should be the same 
as paramter 'exp' except the length of 'dat_dim' dimension. The order of 
dimension can be different. It can also be a vector with the same length as
'exp', then the vector will automatically be 'time_dim' and 'dat_dim' will
be 1.}

\item{time_dim}{A character string indicating the name of dimension along
which the RMSSS are computed. The default value is 'sdate'.}

\item{dat_dim}{A character string indicating the name of dataset (nobs/nexp) 
dimension. The default value is 'dataset'.}

\item{pval}{A logical value indicating whether to compute or not the p-value 
of the test Ho: RMSSS = 0. If pval = TRUE, the insignificant RMSSS will 
return NA. The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list containing the numeric arrays with dimension:\cr 
 c(nexp, nobs, all other dimensions of exp except time_dim).\cr
nexp is the number of experiment (i.e., dat_dim in exp), and nobs is the 
number of observation (i.e., dat_dim in obs).\cr
\item{$rmsss}{
 The root mean square error skill score. 
}
\item{$p.val}{
 The p-value. Only present if \code{pval = TRUE}.
}
}
\description{
Compute the root mean square error skill score (RMSSS) between an array of 
forecast 'exp' and an array of observation 'obs'. The two arrays should 
have the same dimensions except along dat_dim, where the length can be 
different, with the number of experiments/models (nexp) and the number of 
observational datasets (nobs).\cr
RMSSS computes the root mean square error skill score of each jexp in 1:nexp 
against each jobs in 1:nobs which gives nexp * nobs RMSSS for each other 
grid point of the array.\cr
The RMSSS are computed along the time_dim dimension which should corresponds
to the startdate dimension.\cr
The p-value is optionally provided by an one-sided Fisher test.\cr
}
\examples{
set.seed(1)
exp <- array(rnorm(30), dim = c(dataset = 2, time = 3, memb = 5))
set.seed(2)
obs <- array(rnorm(15), dim = c(time = 3, memb = 5, dataset = 1))
res <- RMSSS(exp, obs, time_dim = 'time')

}
