% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bias.R
\name{Bias}
\alias{Bias}
\title{Compute the Mean Bias}
\usage{
Bias(
  exp,
  obs,
  time_dim = "sdate",
  memb_dim = NULL,
  dat_dim = NULL,
  na.rm = FALSE,
  absolute = FALSE,
  time_mean = TRUE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numerical array of the forecast with at least time 
dimension.}

\item{obs}{A named numerical array of the observation with at least time 
dimension. The dimensions must be the same as 'exp' except 'memb_dim' and 
'dat_dim'.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'sdate'.}

\item{memb_dim}{A character string indicating the name of the member dimension
to compute the ensemble mean; it should be set to NULL if the parameter 
'exp' is already the ensemble mean. The default value is NULL.}

\item{dat_dim}{A character string indicating the name of dataset dimension. 
The length of this dimension can be different between 'exp' and 'obs'. 
The default value is NULL.}

\item{na.rm}{A logical value indicating if NAs should be removed (TRUE) or
kept (FALSE) for computation. The default value is FALSE.}

\item{absolute}{A logical value indicating whether to compute the absolute 
bias. The default value is FALSE.}

\item{time_mean}{A logical value indicating whether to compute the temporal 
mean of the bias. The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numerical array of bias with dimensions c(nexp, nobs, the rest dimensions of
'exp' except 'time_dim' (if time_mean = T) and 'memb_dim'). nexp is the number
of experiment (i.e., 'dat_dim' in exp), and nobs is the number of observation 
(i.e., 'dat_dim' in obs). If dat_dim is NULL, nexp and nobs are omitted.
}
\description{
The Mean Bias or Mean Error (Wilks, 2011) is defined as the mean difference 
between the ensemble mean forecast and the observations. It is a deterministic
metric. Positive values indicate that the forecasts are on average too high
and negative values indicate that the forecasts are on average too low.
It also allows to compute the Absolute Mean Bias or bias without temporal 
mean. If there is more than one dataset, the result will be computed for each
pair of exp and obs data.
}
\examples{
exp <- array(rnorm(1000), dim = c(dat = 1, lat = 3, lon = 5, member = 10, sdate = 50))
obs <- array(rnorm(1000), dim = c(dat = 1, lat = 3, lon = 5, sdate = 50))
bias <- Bias(exp = exp, obs = obs, memb_dim = 'member')

}
\references{
Wilks, 2011; https://doi.org/10.1016/B978-0-12-385022-5.00008-7
}
