% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sNPLS_fit.R
\name{sNPLS}
\alias{sNPLS}
\title{Fit a sNPLS model}
\usage{
sNPLS(XN, Y, ncomp = 2, conver = 1e-16, max.iteration = 10000,
  keepJ = rep(ncol(XN), ncomp), keepK = rep(rev(dim(XN))[1], ncomp),
  scale.X = TRUE, center.X = TRUE, scale.Y = TRUE, center.Y = TRUE,
  silent = F)
}
\arguments{
\item{XN}{A three-way array containing the predictors.}

\item{Y}{A matrix containing the response.}

\item{ncomp}{Number of components in the projection}

\item{conver}{Convergence criterion}

\item{max.iteration}{Maximum number of iterations}

\item{keepJ}{Number of variables to keep for each component}

\item{keepK}{Number of 'times' to keep for each component}

\item{scale.X}{Perform unit variance scaling on X?}

\item{center.X}{Perform mean centering on X?}

\item{scale.Y}{Perform unit variance scaling on Y?}

\item{center.Y}{Perform mean centering on Y?}

\item{silent}{Show output?}
}
\value{
A fitted sNPLS model
}
\description{
Fits a N-PLS regression model imposing a L1 penalization on \code{wj} and \code{wk} matrices
}
\examples{
X_npls<-array(rpois(7500, 10), dim=c(50, 50, 3))

Y_npls<-matrix(2+0.4*X_npls[,5,1]+0.7*X_npls[,10,1]-0.9*X_npls[,15,1]+
0.6*X_npls[,20,1]- 0.5*X_npls[,25,1]+rnorm(50), ncol=1)

fit<-sNPLS(X_npls, Y_npls, ncomp=3, keepJ = rep(2,3) , keepK = rep(1,3))
}
\references{
C. A. Andersson and R. Bro. The N-way Toolbox for MATLAB Chemometrics & Intelligent Laboratory Systems. 52 (1):1-4, 2000.

Shen, H. and Huang, J. Z. (2008). Sparse principal component analysis via regularized low rank matrix approximation. Journal of Multivariate Analysis 99, 1015-1034
}
