% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SABARSI.R
\name{signal_detection}
\alias{signal_detection}
\title{Detect signals in background-removed spectra}
\usage{
signal_detection(xr, fdr.c = 0.01, stren.c = 200, wid.c = 5)
}
\arguments{
\item{xr}{A p*n data matrix of background-removed spectra, where n is the number of spectra, and p is the number of frequency channels.}

\item{fdr.c}{A number between 0 and 1, which is the cutoff for FDR.}

\item{stren.c}{A positive number for the cutoff of the strength of a signal.}

\item{wid.c}{A positive number for the cutoff of the width of a signal.}
}
\value{
A list containing the indices of spectra with detected signals, \code{tim.index}, and a matrix recording the peaks of signals, \code{peaks}.
}
\description{
Detect signals in background-removed spectra
}
\examples{
\donttest{
res <- signal_detection(xr)
# xr is the matrix of background removed spectra
# xr can be obtained by background_removal function

head(res$tim.index)  ## check the first few time indices of signals
}
}
