% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss.R
\name{binder}
\alias{binder}
\alias{VI.lb}
\title{Compute a Partition Loss Function}
\usage{
binder(partitions, psm)

VI.lb(partitions, psm)
}
\arguments{
\item{partitions}{An integer matrix of cluster labels, where each row is a
partition given as cluster labels. Two items are in the same subset (i.e.,
cluster) if their labels are equal.}

\item{psm}{A pairwise similarity matrix, i.e., \code{n}-by-\code{n} symmetric
matrix whose \code{(i,j)} element gives the (estimated) probability that
items \code{i} and \code{j} are in the same subset (i.e., cluster) of a
partition (i.e., clustering).}
}
\value{
A numeric vector of length equal to the number of rows of
  \code{partitions}, where each element gives the value of the loss function.
}
\description{
These functions compute the expectation of the Binder loss and the lower
bound of the expectation of the variation of information loss for given
partitions based on the supplied pairwise similarity matrix.
}
\examples{
probs <- psm(iris.clusterings, parallel=FALSE)
binder(iris.clusterings[1:5,], probs)
VI.lb(iris.clusterings[1:5,], probs)

}
