% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allocation.R
\name{allocation}
\alias{allocation}
\title{Strata allocation given a sample size}
\usage{
allocation(Nh, n, var, alloc = c("unif", "prop", "min", "optim"))
}
\arguments{
\item{Nh}{Vector of population strata sizes.}

\item{n}{Sample size}

\item{var}{Vector of strata variances.}

\item{alloc}{The allocation method to be used. Default is "unif".}
}
\value{
Vector of strata sample sizes.
}
\description{
Function to allocate the number of samples to be taken for each
strata given the total sample size and the allocation method. The number of allocations
 returned will be equal to the length of the parameters.
}
\examples{
allocation(rep(125,4), 100, alloc="unif") #25, 25, 25, 25
allocation(c(100, 50, 25), 100, alloc="prop")
}
