% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_data_methods.R
\name{sfn_replacement_methods}
\alias{sfn_replacement_methods}
\alias{get_sapf_data<-,sfn_data-method}
\alias{get_env_data<-,sfn_data-method}
\alias{get_sapf_flags<-,sfn_data-method}
\alias{get_env_flags<-,sfn_data-method}
\alias{get_timestamp<-,sfn_data-method}
\alias{get_solar_timestamp<-,sfn_data-method}
\alias{get_si_code<-,sfn_data-method}
\alias{get_site_md<-,sfn_data-method}
\alias{get_stand_md<-,sfn_data-method}
\alias{get_species_md<-,sfn_data-method}
\alias{get_plant_md<-,sfn_data-method}
\alias{get_env_md<-,sfn_data-method}
\title{sfn_data replacement methods}
\usage{
\S4method{get_sapf_data}{sfn_data}(object) <- value

\S4method{get_env_data}{sfn_data}(object) <- value

\S4method{get_sapf_flags}{sfn_data}(object) <- value

\S4method{get_env_flags}{sfn_data}(object) <- value

\S4method{get_timestamp}{sfn_data}(object) <- value

\S4method{get_solar_timestamp}{sfn_data}(object) <- value

\S4method{get_si_code}{sfn_data}(object) <- value

\S4method{get_site_md}{sfn_data}(object) <- value

\S4method{get_stand_md}{sfn_data}(object) <- value

\S4method{get_species_md}{sfn_data}(object) <- value

\S4method{get_plant_md}{sfn_data}(object) <- value

\S4method{get_env_md}{sfn_data}(object) <- value
}
\arguments{
\item{object}{sfn_data containing the slot to replace}

\item{value}{object with the data to replace snf_Data slot with}
}
\description{
Methods to replace the data and metadata from the sfn_data class slots
}
\details{
The replacement object must be a valid object for that slot:
\itemize{
  \item{For \code{get_sapf_data}, \code{get_env_data}, \code{get_sapf_flags} and
        \code{get_env_flags} a data.frame or tibble without the TIMESTAMP
        variable}
  \item{For \code{get_*_md} a data.frame or tibble}
  \item{For \code{get_timestamp} and \code{get_solar_timestamp} a POSIXct
        vector of length == nrow(sapf/env_data)}
  \item{For \code{get_si_code} a character vector}
}
Validity is automatically checked before modifying the sfn_data object, and
an error is raised if not valid
}
\examples{
# preparation
data('ARG_TRE', package = 'sapfluxnetr')
sapf_data <- get_sapf_data(ARG_TRE, solar = TRUE)

# modifying the slot data
sapf_data[1:10, 2] <- NA

# replacement. Remember, the sfn_data slot does not contain a TIMESTAMP
# variable, it must be removed
get_sapf_data(ARG_TRE) <- sapf_data[,-1]

}
