% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour.R
\name{get_colour_palette}
\alias{get_colour_palette}
\title{Provide A Colour Set for A Number of Requested Colours}
\usage{
get_colour_palette(
  data,
  col_pos,
  colour_palette_nominal = NULL,
  colour_palette_ordinal = NULL,
  colour_na = NULL,
  categories_treated_as_na = NULL,
  call = rlang::caller_env()
)
}
\arguments{
\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_overview 'dep_cat', etc columns.}

\item{col_pos}{Character vector of column names for which colours will be found.}

\item{colour_palette_nominal, colour_palette_ordinal}{\emph{User specified colour set}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

User-supplied default palette, excluding \code{colour_na}.}

\item{colour_na}{\emph{Colour for NA category}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

Colour as a single string for NA values.}

\item{categories_treated_as_na}{\emph{NA categories}

\verb{vector<character>} // \emph{default:} \code{NULL} (\code{optional})

Categories that should be treated as NA.}

\item{call}{\emph{Internal call}

\verb{obj:<call>} // \emph{Default:} \code{rlang::caller_env()} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}
}
\value{
A colour set as character vector, where \code{NA} has the \code{colour_na}, and the rest are taken from colour_palette_nominal if available.
}
\description{
Possibly using colour_palette_nominal if available. If not sufficient, uses a set
palette from RColorBrewer.
}
\examples{
get_colour_palette(ex_survey, col_pos=c("b_1", "b_2"))
get_colour_palette(ex_survey, col_pos=c("b_1", "b_2"),
                  colour_palette_nominal = c("red", "blue", "orange"))
}
