% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/deprecated_convDN2RU.R
\docType{methods}
\name{convDN2RU}
\alias{convDN2RU}
\alias{convDN2RU,RasterLayer-method}
\alias{convDN2RU,RasterStack-method}
\alias{convDN2RU,Satellite-method}
\title{Convert a band's scaled counts to radiance, reflectance and/or temperature}
\usage{
\S4method{convDN2RU}{Satellite}(x, convert = "all",
  szen_correction = "TRUE")

\S4method{convDN2RU}{RasterStack}(x, mult, add, szen, k1, k2)

\S4method{convDN2RU}{RasterLayer}(x, mult, add, szen, k1, k2)
}
\arguments{
\item{x}{An object of class Satellite, raster::RasterStack or
raster::RasterLayer.}

\item{convert}{Type of physical output; one of "rad", "ref", "bt" or "all".}

\item{szen_correction}{Logical; if \code{TRUE}, sun zenith correction is
being applied.}

\item{mult}{Multiplicative coefficient for value transformation (i.e. slope).}

\item{add}{Additive coefficient for value transformation (i.e. offset).}

\item{szen}{Cosine of solar zenith angle.}

\item{k1,k2}{Temperature correction parameters.}
}
\value{
If x is a Satellite object, a Satellite object with added converted
layers; \cr
if x is a \code{raster::Raster*} object, a \code{raster::Raster*}
object with converted layer(s).
}
\description{
Convert a band's scaled counts to radiance, reflectance
and/or brightness temperature using a simple linear conversion without
any kind of atmospheric correction etc.






}
\details{
The conversion functions are taken from USGS' Landsat 8 manual
which is available online at
\url{http://landsat.usgs.gov/Landsat8_Using_Product.php}.
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC8*.tif"), full.names = TRUE)
sat <- satellite(files)
sat <- convDN2RU(sat)

# If you use a raster layer, supply required meta information
bcde <- "B002n"
convDN2RU(x = getSatDataLayer(sat, bcde),
          mult = getSatRADM(sat, bcde),
          add = getSatRADA(sat, bcde))
}
\seealso{
\code{\link{calcAtmosCorr}} for conversions of scaled counts
to physical units including a scene-based atmospheric correction.
}

