% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transf.R
\name{select_bands}
\alias{select_bands}
\alias{select_bands.satres}
\title{Select bands by spatial resolution and name}
\usage{
select_bands(sr, res, bands)

\method{select_bands}{satres}(sr, res = NULL, bands = NULL)
}
\arguments{
\item{sr}{A \code{satres} object.}

\item{res}{A string, spatial resolution.}

\item{bands}{A string, band name.}
}
\value{
A \code{satres} object.
}
\description{
Select the bands of an object based on spatial resolution and band name.
}
\examples{

esa <- system.file("extdata", "esa", package = "satres")
sr <- satres(dir = esa) |>
     select_bands(res = c("r2000m", "r6000m"), bands = c("B02", "B03", "B04"))

}
\seealso{
\code{\link{satres}}

Other satellite transformation: 
\code{\link{clip_bands}()},
\code{\link{merge_tiles}()}
}
\concept{satellite transformation}
