% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items_upsert.R
\name{items_upsert}
\alias{items_upsert}
\title{Upsert many SB items}
\usage{
items_upsert(parent_id = user_id(), title = NULL, ..., info = NULL,
  session = current_session())
}
\arguments{
\item{parent_id}{An \code{\link{sbitem}} object or character ScienceBase ID corresponding to the 
parent item (folder)}

\item{title}{The title of the new SB item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{info}{(optional) list of metadata info for the new item}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
An object of class \code{sbitem}
}
\description{
Either creates or updates (if items already exist)
}
\examples{
\dontrun{
# helper function to make a random name
aname <- function() paste0(sample(letters, size = 5, replace = TRUE), collapse = "")

# Create some item - by default we use your user ID
z1 <- item_create(title = aname())
z2 <- item_create(title = aname())

# Upsert items
(x <- items_upsert(list(z1, z2), title = c(aname(), aname())))

# Call item_upsert again, updates this time
items_upsert(x, info = list(
		contacts = list(list(name = "Suzy"))
	)
)
}
}

