% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_upsert.R
\name{item_upsert}
\alias{item_upsert}
\title{Upsert an SB item}
\usage{
item_upsert(parent_id = user_id(), title = NULL, ..., info = NULL)
}
\arguments{
\item{parent_id}{An \code{\link{sbitem}} object or character ScienceBase ID corresponding to the 
parent item (folder)}

\item{title}{The title of the new SB item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}}

\item{info}{(optional) list of metadata info for the new item}
}
\value{
An object of class \code{sbitem}
}
\description{
Either creates or updates (if item already exists)
}
\examples{
\dontrun{
# helper function to make a random name
aname <- function() paste0(sample(letters, size = 5, replace = TRUE), collapse = "")

# Create an item - by default we use your user ID
(x <- item_upsert(title = aname()))

# Call item_upsert again, updates this time
item_upsert(x, info = list(
		contacts = list(list(name = "Suzy"))
	)
)
}
}
