% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{FeaturePlot_DualAssay}
\alias{FeaturePlot_DualAssay}
\title{Customize FeaturePlot of two assays}
\usage{
FeaturePlot_DualAssay(
  seurat_object,
  features,
  assay1 = "RAW",
  assay2 = "RNA",
  colors_use = viridis_plasma_dark_high,
  na_color = "lightgray",
  order = TRUE,
  pt.size = NULL,
  aspect_ratio = NULL,
  reduction = NULL,
  na_cutoff = 1e-09,
  raster = NULL,
  raster.dpi = c(512, 512),
  slot = "data",
  num_columns = NULL,
  alpha_exp = NULL,
  alpha_na_exp = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Feature(s) to plot.}

\item{assay1}{name of assay one.  Default is "RAW" as featured in \code{\link{Create_CellBender_Merged_Seurat}}}

\item{assay2}{name of assay two  Default is "RNA" as featured in \code{\link{Create_CellBender_Merged_Seurat}}}

\item{colors_use}{list of colors or color palette to use.}

\item{na_color}{color to use for points below lower limit.}

\item{order}{whether to move positive cells to the top (default = TRUE).}

\item{pt.size}{Adjust point size for plotting.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{na_cutoff}{Value to use as minimum expression cutoff.  To set no cutoff set to \code{NA}.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{slot}{Which slot to pull expression data from?  Default is "data".}

\item{num_columns}{Number of columns in plot layout.  If number of features > 1 then \code{num_columns}
dictates the number of columns in overall layout (\code{num_columns = 1} means stacked layout & \code{num_columns = 2}
means adjacent layout).}

\item{alpha_exp}{new alpha level to apply to expressing cell color palette (\code{colors_use}).  Must be
value between 0-1.}

\item{alpha_na_exp}{new alpha level to apply to non-expressing cell color palette (\code{na_color}).  Must be
value between 0-1.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{FeaturePlot}}.}
}
\value{
A ggplot object
}
\description{
Create Custom FeaturePlots and preserve scale (no binning) from same features in two assays
simultaneously.  Intended for plotting same modality present in two assays.
}
\examples{
\dontrun{
FeaturePlot_DualAssay(seurat_object = object, features = "Cx3cr1", assay1 = "RAW", assay2 = "RNA",
colors_use = viridis_plasma_dark_high, na_color = "lightgray")
}

}
\concept{seurat_plotting}
