% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{VariableFeaturePlot_scCustom}
\alias{VariableFeaturePlot_scCustom}
\title{Custom Labeled Variable Features Plot}
\usage{
VariableFeaturePlot_scCustom(
  seurat_object,
  num_features = 10,
  custom_features = NULL,
  label = TRUE,
  pt.size = 1,
  colors_use = c("black", "red"),
  repel = TRUE,
  y_axis_log = FALSE,
  assay = NULL,
  selection.method = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{num_features}{Number of top variable features to highlight by color/label.}

\item{custom_features}{A vector of custom feature names to label on plot instead of labeling top
variable genes.}

\item{label}{logical. Whether to label the top features.  Default is TRUE.}

\item{pt.size}{Adjust point size for plotting.}

\item{colors_use}{colors to use for plotting.  Default is "black" and "red".}

\item{repel}{logical (default TRUE).  Whether or not to repel the feature labels on plot.}

\item{y_axis_log}{logical. Whether to change y axis to log10 scale (Default is FALSE).}

\item{assay}{Assay to pull variable features from.}

\item{selection.method}{If more then one method use to calculate variable features specify which
method to use for plotting.  See \code{selection.method} parameter in \code{\link[Seurat]{VariableFeaturePlot}}
for list of options.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{VariableFeaturePlot}}.}
}
\value{
A ggplot object
}
\description{
Creates variable features plot with N number of features already labeled by default.
}
\examples{
library(Seurat)
VariableFeaturePlot_scCustom(seurat_object = pbmc_small, num_features = 10)

}
\concept{seurat_plotting}
