% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{CheckMatrix_scCustom}
\alias{CheckMatrix_scCustom}
\title{Check Matrix Validity}
\usage{
CheckMatrix_scCustom(
  object,
  checks = c("infinite", "logical", "integer", "na")
)
}
\arguments{
\item{object}{A matrix}

\item{checks}{Type of checks to perform, choose one or more from:
\itemize{
\item \dQuote{\code{infinite}}: Emit a warning if any value is infinite
\item \dQuote{\code{logical}}: Emit a warning if any value is a logical
\item \dQuote{\code{integer}}: Emit a warning if any value is \emph{not}
an integer
\item \dQuote{\code{na}}: Emit a warning if any value is an \code{NA}
or \code{NaN}
}}
}
\value{
Emits warnings for each test and invisibly returns \code{NULL}
}
\description{
Native implementation of SeuratObjects CheckMatrix but with modified warning messages.
}
\examples{
\dontrun{
mat <- Read10X(...)
CheckMatrix_scCustom(object = mat)
}

}
\references{
Re-implementing \code{CheckMatrix} only for sparse matrices with modified warning messages.  Original function from SeuratObject \url{https://github.com/mojaveazure/seurat-object/blob/9c0eda946e162d8595696e5280a6ecda6284db39/R/utils.R#L625-L650} (License: MIT).
}
\concept{helper_util}
