% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nebulosa_Plotting.R
\name{Plot_Density_Joint_Only}
\alias{Plot_Density_Joint_Only}
\title{Nebulosa Joint Density Plot}
\usage{
Plot_Density_Joint_Only(
  seurat_object,
  features,
  viridis_palette = "magma",
  custom_palette = NULL,
  pt.size = 1,
  aspect_ratio = NULL,
  reduction = NULL,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Features to plot.}

\item{viridis_palette}{default viridis palette to use (must be one of: "viridis", "magma", "cividis",
"inferno", "plasma").  Default is "magma".}

\item{custom_palette}{non-default color palette to be used in place of default viridis options.}

\item{pt.size}{Adjust point size for plotting.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{...}{Extra parameters passed to \code{\link[Nebulosa]{plot_density}}.}
}
\value{
A ggplot object
}
\description{
Return only the joint density plot from Nebulosa plot_density function.  Requires Nebulosa package from Bioconductor.
}
\examples{
\donttest{
library(Seurat)
Plot_Density_Joint_Only(seurat_object = pbmc_small, features = c("CD8A", "CD3E"))
}

}
\concept{other_seurat_plotting}
