% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prop_associations.R
\name{plot_donor_props}
\alias{plot_donor_props}
\title{Plot donor celltype/subtype proportions against each factor}
\usage{
plot_donor_props(
  donor_props,
  donor_scores,
  significance,
  ctype_mapping = NULL,
  stat_type = "adj_pval",
  n_col = 2
)
}
\arguments{
\item{donor_props}{data.frame Donor proportions as output from compute_donor_props()}

\item{donor_scores}{data.frame Donor scores from tucker results}

\item{significance}{numeric F-Statistics as output from compute_associations()}

\item{ctype_mapping}{character The cell types corresponding with columns of donor_props (default=NULL)}

\item{stat_type}{character Either "fstat" to get F-Statistics, "adj_rsq" to get adjusted
R-squared values, or "adj_pval" to get adjusted pvalues (default='adj_pval')}

\item{n_col}{numeric The number of columns to organize the plots into (default=2)}
}
\value{
A cowplot figure of ggplot objects for proportions of each cell type against
donor factor scores for each factor.
}
\description{
Plot donor celltype/subtype proportions against each factor
}
