% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{colMeanVars}
\alias{colMeanVars}
\title{Calculates column mean and variance. Adapted from pagoda2.
https://github.com/kharchenkolab/pagoda2/blob/main/src/misc2.cpp}
\usage{
colMeanVars(sY, rowSel, ncores = 1L)
}
\arguments{
\item{sY}{sparse matrix Gene by cell matrix of counts}

\item{rowSel}{numeric The selected rows (genes)}

\item{ncores}{numeric The number of cores}
}
\value{
data.frame with columns of mean, variance, and number of observeatios 
for each gene across samples
}
\description{
Calculates column mean and variance. Adapted from pagoda2.
https://github.com/kharchenkolab/pagoda2/blob/main/src/misc2.cpp
}
\examples{
library(Matrix)
donor_by_gene <- rbind(c(9,2,1,5), c(3,3,1,2))
donor_by_gene <- Matrix(donor_by_gene, sparse = TRUE)
result <- colMeanVars(donor_by_gene, rowSel = NULL, ncores=1)
}
