\name{smooth.construct.tismi.smooth.spec}
%\Rdversion{1.1}
\alias{smooth.construct.tismi.smooth.spec}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Tensor product interaction with increasing constraint along the first
 covariate and unconstrained along the second covariate

}
\description{This is a special method function
  for creating tensor product bivariate interaction smooths with increasing constraint in the first covariate,
  appropriate when the main effects (and any lower interactions) are also present.
 It is built by the \code{mgcv} constructor function for smooth terms, \code{smooth.construct}, and constructed from a pair of single penalty marginal smooths. This tensor product is specified by model terms such as \code{s(x1,x2,k=c(q1,q2),bs="tismi")}.
 See example below. 
  

}
\usage{
\method{smooth.construct}{tismi.smooth.spec}(object, data, knots)
}
\arguments{
   \item{object}{A smooth specification object, generated by an \code{s} term in a GAM formula.} 

  \item{data}{A data frame or list containing the values of the elements of \code{object$term},
     with names given by \code{object$term}.}
 
  \item{knots}{An optional list containing the knots corresponding to \code{object$term}. 
          If it is \code{NULL} then the knot locations are generated automatically.}
 
}
\details{
  In some cases, it is helpful to consider models with a main-effects + interactions structure, for example,
\deqn{f_1(x)  + f_2(z) + f_3(x,z)}{f_1(x)  + f_2(z) + f_3(x,z),}
where \eqn{f_1} and \eqn{f_2} are smooth `main effects' and \eqn{f_3} is a smooth `interaction' subject to increasing constraint wrt \eqn{x} (\eqn{f_1} can be subject to increasing constraint). 

Constructing such functional ANOVA decomposition recognises the fact that the tensor produc basis construction is exactly the same as the construction used for any interaction in a linear model. \code{tismi} produce tensor product interactions with increasing constraint along the first covariate from which the main effects have been excluded, under the assumption that they will be included separately. For example, the \code{~ s(x) + s(z) + s(x,z,bs="tismi")} would produce the above main effects + interaction structure. Specifically, the marginal smooths of a tensor product, \code{tismi}, are subject to identifiability constraints before constructing the tensor product basis. This results in the interaction smooths that do not include the corresponding main effects. \code{tismi} apply SCOP identifiability constraints to the first marginal and sum-to-zero constraints to the second unconstrained marginal. See Wood (2017, section 5.6.3) for ANOVA decompositions of unconstrained smooths.

}
\value{An object of class \code{"tismi.smooth"}. In addition to the usual 
elements of a smooth class documented under \code{smooth.construct} of the \code{mgcv} library, 
this object contains:
\item{p.ident}{A vector of 0's and 1's for model parameter identification: 
     1's indicate parameters which will be exponentiated, 0's - otherwise.}
\item{Zc}{A matrix of identifiability constraints.}
\item{margin.bs}{A two letter character string indicating the (penalized) smoothing basis to use for the second unconstrained marginal smooth. (eg \code{"cc"} for cyclic cubic regression spline).}

}
\references{
 Pya, N. and Wood, S.N. (2015) Shape constrained additive models. Statistics and Computing, 25(3), 543-559

Wood S.N. (2017) Generalized Additive Models: An Introduction with R (2nd edition). Chapman
and Hall/CRC Press

}
\author{ 
  Natalya Pya \email{nat.pya@gmail.com}
}


\seealso{
\code{\link{smooth.construct.tismd.smooth.spec}}

\code{\link{smooth.construct.tesmi1.smooth.spec}}
}
\examples{
  \dontrun{
## tensor product `tismi' example... 
require(scam)
test <- function(x,z){
  exp(4*x)/(1+exp(4*x))+2*sin(pi*z)+(x+1)^0.6*z
}
set.seed(7)
n <- 600
x <- runif(n)*4-1
z <- runif(n)
xs <- seq(-1,3,length=30); zs <- seq(0,1,length=30)
pr <- data.frame(x=rep(xs,30),z=rep(zs,rep(30,30)))
truth <- matrix(test(pr$x,pr$z),30,30)
f <- test(x,z)
y <- f + rnorm(n)*0.3
bi <- scam(y~ ti(x)+ti(z)+ s(x,z,bs="tismi"))
summary(bi)
old.par <- par(mfrow=c(2,2))
persp(xs,zs,truth);title("truth")
vis.scam(bi);title("tismi")

## fitting with "tesmi1"...
bc <- scam(y~s(x,z,bs="tesmi1"))
vis.scam(bc);title("tesmi1")
par(old.par)

plot(bi,pages=1,scheme=2)
plot(bi,select=3,scheme=1,zlim=c(-5,5)) 

 }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models} \keyword{regression}%-- one or more ..
