% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_u.R
\name{tau_u}
\alias{tau_u}
\title{Tau-U for single-case data}
\usage{
tau_u(
  data,
  dvar,
  pvar,
  tau_method = "b",
  method = "complete",
  phases = c(1, 2),
  meta_method = "random",
  ci = 0.95,
  continuity_correction = FALSE
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{tau_method}{Character with values "a" or "b" (default) indicating 
whether Kendall Tau A or Kendall Tau B is applied.}

\item{method}{\code{"complete"} (default) or \code{"parker"}. The latter
calculates the number of possible pairs as described in Parker et al. (2011)
which might lead to tau-U values greater than 1.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases =
c(2,4)} for comparing the second to the fourth phase. Phases could be
combined by providing a list with two elements. E.g., \code{phases = list(A
= c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4
(as B). Default is \code{phases = c("A","B")}.}

\item{meta_method}{Character string. If set "random", a random-effect 
meta-analysis is calculated. If set "fixed", a fixed-effect meta-analysis is 
calculated. If set "none", no meta-analysis is conducted (may be helpful to 
speed up analyses).}

\item{ci}{Confidence interval for meta analyzes.}

\item{continuity_correction}{If TRUE, a continuity correction is applied for 
calculating p-values of correlations (here: S will be reduced by one before calculating Z)}
}
\value{
\item{table}{A data frame containing statistics from the Tau-U
family, including: Pairs, positive and negative comparisons, S, and Tau}
\item{matrix}{The matrix of comparisons used for calculating the
statistics.} \item{tau_u}{Tau-U value.}
}
\description{
This function calculates indices of the Tau-U family as proposed by Parker
et al. (2011).
}
\details{
Tau-U is an inconsistently operationalized construct. Parker et al.
(2011) describe a method which may result in Tau-U lager than 1. 
A different implementation of the method 
(provided at http://www.singlecaseresearch.org/calculators/tau-u) uses 
tau-b (instead of tau-a as in the original formulation by Parker). 
Bossart et. al (2018) describe inconsistencies in the results from this
implementation as well. Another problems lies in the calculation in overall 
Tau-U values from several single cases. The function presented here 
applies a metaanalyzes to gain the overall values. Each tau value is 
weighted by the inverse of the variance (ie. the tau standard error). 
Tau values are not converted to Pearson r values. The argument 
\code{"meta_method"} calculates a random-effect model ("random") or 
a fixed effect model ("fixed").
}
\examples{

tau_u(Grosche2011$Eva)

## Replicate  tau-U calculation from Parker et al. (2011)
bob <- scdf(c(A = 2, 3, 5, 3, B = 4, 5, 5, 7, 6), name = "Bob")
res <- tau_u(bob, method = "parker", tau_method = "a")
print(res, complete = TRUE)

## Request tau-U for all single-cases from the Grosche2011 data set
tau_u(Grosche2011)
}
\references{
Brossart, D. F., Laird, V. C., & Armstrong, T. W. (2018). 
Interpreting Kendall’s Tau and Tau-U for single-case experimental designs. 
\emph{Cogent Psychology, 5(1)}, 1–26. 
https://doi.org/10.1080/23311908.2018.1518687.

Parker, R. I., Vannest, K. J., Davis, J. L., & Sauber, S. B.
(2011). Combining Nonoverlap and Trend for Single-Case Research: Tau-U.
\emph{Behavior Therapy, 42}, 284-299.
}
\seealso{
Other overlap functions: 
\code{\link{corrected_tau}()},
\code{\link{nap}()},
\code{\link{overlap}()},
\code{\link{pand}()},
\code{\link{pem}()},
\code{\link{pet}()},
\code{\link{pnd}()}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
