% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rci.R
\name{rci}
\alias{rci}
\title{Reliable change index}
\usage{
rci(data, dvar, pvar, rel, ci = 0.95, graph = FALSE, phases = c(1, 2))
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{rel}{Reliability of the measure, used to compute the standard error.}

\item{ci}{Width of confidence interval as a decimal. Default is \code{ci =
0.95} applying a 95\%-confidence interval.}

\item{graph}{If set \code{TRUE}, a box plot of phase A and B scores is
displayed. \code{graph = FALSE} by default.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases =
c(2,4)} for comparing the second to the fourth phase. Phases could be
combined by providing a list with two elements. E.g., \code{phases = list(A
= c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4
(as B). Default is \code{phases = c(1,2)}.}
}
\description{
\bold{CAUTION! This function is still under development and not ready for
use!} The \code{rciSC} function computes three indices of reliable change
(Wise, 2004) and corresponding descriptive statistics.
}
\examples{

## Report the RCIs of the first case from the byHeart data and include a graph
rci(byHeart2011[1], graph = TRUE, rel = 0.8)

}
\references{
Christensen, L., & Mendoza, J. L. (1986). A method of assessing
change in a single subject: An alteration of the RC index. \emph{Behavior
Therapy, 17}, 305-308.

Hageman, W. J. J., & Arrindell, W. A. (1993). A further refinement of the
reliable change (RC) index by improving the pre-post difference score:
Introducing RCID. \emph{Behaviour Research and Therapy, 31}, 693-700.

Jacobson, N. S., & Truax, P. (1991). Clinical Significance: A statistical
approach to defining meaningful change in psychotherapy research.
\emph{Journal of Consulting and Clinical Psychology, 59}, 12-19.

Wise, E. A. (2004). Methods for analyzing psychotherapy outcomes: A review
of clinical significance, reliable change, and recommendations for future
directions. \emph{Journal of Personality Assessment, 82}, 50 - 59.
}
\author{
Juergen Wilbert
}
