% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{add_duration}
\alias{add_duration}
\title{Add a column \code{duration} to a \code{data.table} with column \code{time}.}
\usage{
add_duration(d, keys = NULL, silent = TRUE)
}
\arguments{
\item{d}{A \code{data.table} containing at least a column \code{time},
which is sortable. For example, could be POSIXct dates.}

\item{keys}{A character vector for the columns you wish the output table to 
be keyed by.}

\item{silent}{Should the table be modified and this function return nothing
(silent = TRUE), or should the function return the modified table (silent
= FALSE).}
}
\value{
The input \code{data.table}, with a column \code{duration} added.
}
\description{
Adds a column \code{duration} to a \code{data.table} with column \code{time},
the most recent time given a duration of 1, the second most recent time 
given a duration of 2, and so on. This function \strong{modifies} the input
table.
}
\keyword{internal}

